<?PHP

/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* sform Class 	based on SFORM developped by P.Brunier 2001, 2002,      */
/*  2003 and 2004														*/
/*																		*/
// Simple Form generator  SFORM / version 1.22
// Classe to manage several Form in a single database(MySql) in XML Format
// P.Brunier 2001, 2002, 2003 and 2004
//
// This program is free software. You can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License.
//
// Based on Form_Handler 19-4-01 Copyright Drs. Jelte 'YeeHaW' Werkhoven
/* ******************************************************************** */

if (preg_match("#becms_sform_class.php#i", $_SERVER['PHP_SELF'])) { die ("Access Denied"); }

require_once("core/minixml/minixml.inc.php");

// Constante
   define('CRLF', "\n", TRUE);
   if (!$sform_path) {
      $sform_path="core/";
   }
################################################################################################
class form_handler {
  var $form_fields=array();// form fields
  var $title;// form title
  var $mess; // obligatoire message
  var $form_title; // form title
  var $form_method; // form method (Post or Get)
  var $form_key; // form key (for mysql stockage)
  var $form_key_value; // value of the form key (for mysql stockage)
  var $form_key_status="open"; // Status of the key (open or close)
  var $submit_value=""; // the name off all submit buttons of the form
  var $form_password_access=""; // Protect the data with a password
  var $answer=""; // answer table
  var $form_check="true"; // sring which will be inserted into javascript check function
  var $url; // path at 'action' option of form
  var $field_size=50; // Value of the size attribute off a form-field
  var $db; // database handler
  var $prefix="";
  var $form_id="";
  var $form_name="";
  var $form_description="";
  var $form_author="";

  /**
   * form_handler (Constuctor)
   * @param database handler
   *
   */
  function form_handler($db,$prefix){
  $this->db=$db;
  $this->prefix=$prefix;
  }
  /**************************************************************************************/
  // Interrogate the object for identify the position of an item
  // public void
  function interro_fields($ibid) {
    $number="no";
    for(Reset($this->form_fields),$node=0;$node<count($this->form_fields);Next($this->form_fields),$node++) {
       if ($ibid==$this->form_fields[$node]['name']) {
          $number=$node;
          break;
       }
    }
    return ($number);
  }

  function interro_array($ibid0,$ibid1) {
    $number="no";
    while(list($key,$val)=each($ibid0) ){
       if ($ibid1==$val['en']) {
          $number=$key;
          break;
       }
    }
    return ($number);
  }

  /**************************************************************************************/
  // Change the default (50) value for the html attribute SIZE of form-field
  // public void
  function add_form_field_size($en) {
    $this->field_size=$en;
  }

  /**************************************************************************************/
  // add title of <form> / This is also the id_form field in the database (unique)
  // public void
  function add_form_title($en) {
    $this->form_title=$en;
  }

  /**************************************************************************************/
  // add method of <form action=> Get or Post
  // public void
  function add_form_method($en) {
    $this->form_method=$en;
  }

  /**************************************************************************************/
  // add form check after submit for obligatory fields
  // public void
  function add_form_check($en) {
    $this->form_check=$en;
  }

  /**************************************************************************************/
  // add the return url after action
  // public void
  function add_url($en) {
    $this->url=$en;
  }

  /**************************************************************************************/
  // designate a specfific field off the form as key in the DB
  // public void
  function add_key($en) {
    $this->form_key=$en;
  }

  /**************************************************************************************/
  // add the name for all submit buttons of <form>
  // public void
  function add_submit_value($en) {
    $this->submit_value=$en;
  }

  /**************************************************************************************/
  // Lock the Key of <form> for disable edit
  // public void
  function key_lock($en) {
     if ($en=="open") {
        $this->form_key_status="open";
     } else {
        $this->form_key_status="close";
     }
  }

  /**************************************************************************************/
  // add mess
  // public void
  function add_mess($en) {
    $this->mess=$en;
  }

  /**************************************************************************************/
  // add fields text,hidden,textarea,password,submit,reset
  // public void
  function add_field($name,$en, $value='', $type='text', $obligation=false, $size='50', $diviseur='5', $ctrl='') {
    if ($type=="submit") {$name=$this->submit_value;}
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'type'=>$type,
      'en'=>$en,
      'value'=>$value,
      'size'=>$size,
      'diviseur'=>$diviseur,
      'obligation'=>$obligation,
      'ctrl'=>$ctrl
    );
  }

  /**************************************************************************************/
  // add field checkbox
  // public void
  function add_checkbox($name, $en, $value='', $obligation=false, $checked=false) {
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'en'=>$en,
      'value'=>$value,
      'type'=>"checkbox",
      'checked'=>$checked,
      'obligation'=>$obligation
    );
  }

  /**************************************************************************************/
  // add field select
  // public void
  function add_select($name, $en, $values, $obligation=false, $size=1, $multiple=false) {
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'en'=>$en,
      'type'=>"select",
      'value'=>$values,
      'size'=>$size,
      'multiple'=>$multiple,
      'obligation'=>$obligation
    );
  }

  /**************************************************************************************/
  // add field radio
  // public void
  function add_radio($name, $en, $values, $obligation=false) {
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'en'=>$en,
      'type'=>"radio",
      'value'=>$values,
      'obligation'=>$obligation
    );
  }

  /**************************************************************************************/
  // add fields date or stamp : date field of type date, stamp hidden field value timestamp
  // public void
  function add_date($name, $en, $value, $type='date', $modele='m/d/Y', $obligation=false, $size='10') {
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'type'=>$type,
      'model'=>$modele,
      'en'=>$en,
      'value'=>$value,
      'size'=>$size,
      'obligation'=>$obligation,
      'ctrl'=>'date'
    );
  }

  /**************************************************************************************/
  // add title of the HTML tab
  // public void
  function add_title($en) {
    $this->title=$en;
  }

  /**************************************************************************************/
  // add comment into HTML tab
  // public void
  function add_comment($en) {
    $this->form_fields[count($this->form_fields)]=array(
      'en'=>$en,
      'type'=>"comment"
    );
  }

  /**************************************************************************************/
  // add extra into HTML tab (link html tags ...)
  // public void
  function add_extra($en) {
    $this->form_fields[count($this->form_fields)]=array(
      'en'=>$en,
      'type'=>"extra"
    );
  }

  /**************************************************************************************/
  // add field EXTENDER javas only for select field, html for all fields except radio
  // public void
  function add_extender($name, $javas, $html) {
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name."extender",
      'javas'=>$javas,
      'html'=>$html
    );
  }

  /**************************************************************************************/
  // add upload field (only for design, no upload mechanism is inside sform)
  // public void
  function add_upload($name, $en, $size='50', $file_size) {
    $this->form_fields[count($this->form_fields)]=array(
      'name'=>$name,
      'en'=>$en,
      'value'=>"",
      'type'=>"upload",
      'size'=>$size,
      'file_size'=>$file_size
    );
  }


  /**************************************************************************************/
  // print <form> into html output / IF no method (form_method) is affected : the <form>  </form> is not write (useful to insert SFORM in existing form)
  // public string
  function print_form($bg) {
    global $sform_path;
    //$str ="<LINK rel=\"StyleSheet\" HREF=\"".$sform_path."sform.css\" TYPE=\"text/css\">";
    if ($this->form_method!="") {
       $str.="<form action=\"".$this->url."\" method=\"".$this->form_method."\" name=\"".$this->form_title."\" enctype=\"multipart/form-data\"";
       if ($this->form_check=="true") {
           $str.=" onsubmit='return check();'>";
       } else {
           $str.=">";
       }
    }

    $str.="<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\" class=\"LIGNA\"><tr><td>";
    $str.="<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\" class=\"LIGNB\">";
    $str.="<tr class=\"LIGNA\"><td width=\"45%\" align=\"center\"><b>".$this->title."</b></td><td align=\"center\"><span style=\"font-size: 10px;\">".$this->mess."</span></td></tr>";
    $str.="<tr><td width=\"40%\"></td><td></td></tr>";

    for($i=0;$i<count($this->form_fields);$i++){
      if ($this->form_fields[$i]['size']>=$this->field_size) {$csize=$this->field_size;} else {$csize=$this->form_fields[$i]['size']+1;}
      $num_extender=$this->interro_fields($this->form_fields[$i]['name']."extender");
      switch($this->form_fields[$i]['type']){
        case 'text':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $this->form_fields[$i]['value']=preg_replace("#'#","&#039;",$this->form_fields[$i]['value']);

          if ($this->form_fields[$i]['obligation']){
             $this->form_check.=" && (f.elements['".$this->form_fields[$i]['name']."'].value!='')";
             $str.="&nbsp;<span class=\"ROUGE\">*</span></td><td>";
          } else $str.="</td><td>";

          // Charge la valeur et analyse la clef
          $str_clefclose="";
          if ($this->form_fields[$i]['name']==$this->form_key) {
             $this->form_key_value=$this->form_fields[$i]['value'];
             if ($this->form_key_status=="close") {
                $str.="<input class=\"TEXTBOX_STANDARD\" type=\"hidden\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\" size=\"".$csize."\" maxlength=\"".$this->form_fields[$i]['size']."\"";
                $str_clefclose="<b>".$this->form_fields[$i]['value']."</b";
             } else {
                $str.="<input class=\"TEXTBOX_STANDARD\" type=\"".$this->form_fields[$i]['type']."\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\" size=\"".$csize."\" maxlength=\"".$this->form_fields[$i]['size']."\"";
             }
          } else {
             $str.="<input class=\"TEXTBOX_STANDARD\" type=\"".$this->form_fields[$i]['type']."\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\" size=\"".$csize."\" maxlength=\"".$this->form_fields[$i]['size']."\"";
          }
          if ($num_extender!="no") {
             $str.=" ".$this->form_fields[$num_extender]['javas'].">";
             $str.=$this->form_fields[$num_extender]['html'];
          } else {
             $str.="> ";
          }
          $str.=$str_clefclose."</td></tr>";
          break;

        case 'password-access':
          $this->form_fields[$i]['value']=$this->form_password_access;
        case 'password':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $this->form_fields[$i]['value']=preg_replace("#'#","&#039;",$this->form_fields[$i]['value']);

          if ($this->form_fields[$i]['obligation']){
             $this->form_check.=" && (f.elements['".$this->form_fields[$i]['name']."'].value!='')";
             $str.="&nbsp;<span class=\"ROUGE\">*</span></td><td>";
          } else $str.="</td><td>";
          $str.="<input class=\"TEXTBOX_STANDARD\" type=\"".$this->form_fields[$i]['type']."\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\" size=\"".$csize."\" maxlength=\"".$this->form_fields[$i]['size']."\">";
          if ($num_extender!="no") {
             $str.=$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'checkbox':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.=($this->form_fields[$i]['obligation'])? "&nbsp;<span class=\"ROUGE\">*</span></td><td>" : "</td><td>";
          $str.="<input type=\"checkbox\" name=\"".$this->form_fields[$i]['name']."\"";
          $str.=" value=\"".$this->form_fields[$i]['value']."\"";
          $str.=($this->form_fields[$i]['checked'])? " checked>" : ">";
          if ($num_extender!="no") {
             $str.=$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'textarea':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $this->form_fields[$i]['value']=preg_replace("#'#","&#039;",$this->form_fields[$i]['value']);

          if ($this->form_fields[$i]['obligation']){
             $this->form_check.=" && (f.elements['".$this->form_fields[$i]['name']."'].value!='')";
             $str.="&nbsp;<span class=\"ROUGE\">*</span></td><td>";
          } else $str.="</td><td>";
          $txt_row=$this->form_fields[$i]['diviseur'];
          $txt_col=( ($this->form_fields[$i]['size'] - ($this->form_fields[$i]['size'] % $txt_row)) / $txt_row);
          $str.="<textarea class=\"TEXTBOX_STANDARD\" name=\"".$this->form_fields[$i]['name']."\" cols=\"$txt_col\" rows=\"$txt_row\" style=\"width: 100%;\">".$this->form_fields[$i]['value']."</textarea>";
          if ($num_extender!="no") {
             $str.=$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'show-hidden':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en']."</td>";
          if ($num_extender!="no") {
             $str.="<td>".$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";

        case 'hidden':
          $this->form_fields[$i]['value']=preg_replace("#'#","&#039;",$this->form_fields[$i]['value']);
          $str.="<input type=\"hidden\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\">";
          break;

        case 'select':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<select class=\"TEXTBOX_STANDARD\" name=\"".$this->form_fields[$i]['name'];
          $str.=($this->form_fields[$i]['multiple'])? "[]\" multiple" : "\"";
          if ($num_extender!="no") {
             $str.=" ".$this->form_fields[$num_extender]['javas']." ";
          }
          $str.=($this->form_fields[$i]['size'] > 1)? " size=\"".$this->form_fields[$i]['size']."\">" : "\">";
          while(list($key,$val)=each($this->form_fields[$i]['value']) ){
            $str.="<option value=\"".$key."\"";
            $str.=($val['selected'])? " selected>" : ">";
            $str.=preg_replace("#'#","&#039;",$val['en'])."</option>";
          }
          $str.="</select>";
          if ($num_extender!="no") {
             $str.=$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'radio':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          while(list($key,$val)=each($this->form_fields[$i]['value']) ){
            $str.="<input type=\"radio\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$key."\"";
            $str.=($val['checked'])? " checked>&nbsp;" : ">&nbsp;";
            $str.=$val['en']."<br />";
          }
          if ($num_extender!="no") {
             $str.=$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'comment':
          $str.="<tr $bg><td colspan=\"2\">";
          $str.=$this->form_fields[$i]['en'];
          $str.="</td></tr>";
          break;

        case 'extra':
          $str.=$this->form_fields[$i]['en'];
          break;

        case 'submit':
          $this->form_fields[$i]['value']=preg_replace("#'#","&#039;",$this->form_fields[$i]['value']);
          $str.=$this->form_fields[$i][$this->lang];
          $str.="<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\">";
          break;

        case 'reset':
          $this->form_fields[$i]['value']=preg_replace("#'#","&#039;",$this->form_fields[$i]['value']);
          $str.=$this->form_fields[$i]['en'];
          $str.="<input class=\"BOUTON_STANDARD\" type=\"reset\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\">";
          break;

        case 'stamp':
          if ($this->form_fields[$i]['value']=="") $this->form_fields[$i]['value']=strtotime("now");
          if ($this->form_fields[$i]['name']==$this->form_key) {
             $this->form_key_value=$this->form_fields[$i]['value'];
          }
          $str.="<input type=\"hidden\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\">";
          break;

        case 'date':
          if ($this->form_fields[$i]['value']=="") $this->form_fields[$i]['value']=date($this->form_fields[$i]['model']);
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          if ($this->form_fields[$i]['obligation']){
             $this->form_check.=" && (f.elements['".$this->form_fields[$i]['name']."'].value!='')";
             $str.="&nbsp;<span class=\"ROUGE\">*</span></td><td>";
          } else $str.="</td><td>";
          if ($this->form_fields[$i]['name']==$this->form_key) {
             $this->form_key_value=$this->form_fields[$i]['value'];
             if ($this->form_key_status=="close") {
                $str.="<input type=\"hidden\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\">";
                $str.="<b>".$this->form_fields[$i]['value']."</b>";
             } else {
                $str.="<input class=\"TEXTBOX_STANDARD\" type=\"".$this->form_fields[$i]['type']."\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\" size=\"".$csize."\" maxlength=\"".$this->form_fields[$i]['size']."\">";
             }
          } else {
             $str.="<input class=\"TEXTBOX_STANDARD\" type=\"".$this->form_fields[$i]['type']."\" name=\"".$this->form_fields[$i]['name']."\" value=\"".$this->form_fields[$i]['value']."\" size=\"".$csize."\" maxlength=\"".$this->form_fields[$i]['size']."\">";
          }
          if ($num_extender!="no") {
             $str.=$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'upload':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en']."</td>";
          $str.="<td><input class=\"TEXTBOX_STANDARD\" type=\"file\" name=\"".$this->form_fields[$i]['name']."\" size=\"".$csize."\" maxlength=\"".$this->form_fields[$i]['size']."\">";
          $str.="<input type=\"hidden\" name=\"MAX_FILE_SIZE\" value=\"".$this->form_fields[$i]['file_size']."\">";
          if ($num_extender!="no") {
             $str.=$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        default:
          break;
      }
    }
    $str.="</table>";
    $str.="</td></tr></table>";
    if ($this->form_method!="") {
       $str.="</form>";
    }
    if ($this->form_check!="false"){
       $str.="<script type=\"text/javascript\" language=\"JavaScript\">".CRLF;
       $str.="var f=document.forms['".$this->form_title."'];".CRLF;
       $str.="function check(){".CRLF;
       $str.=" if(".$this->form_check."){".CRLF;
       $str.="   f.submit();".CRLF;
       $str.="   return true;".CRLF;
       $str.=" } else {".CRLF;
       $str.="   alert('".$this->mess."');".CRLF;
       $str.="   return false;".CRLF;
       $str.="}}".CRLF;
       $str.="</script>";
    }
    return $str;
  }

  /**************************************************************************************/
  // return ALL FIELDS as HIDDEN
  // public string
  function print_form_hidden() {
    for ($i=0;$i<count($this->form_fields);$i++) {
        $str.="<input type=\"hidden\" name=\"".$this->form_fields[$i]['name']."\" value=\"".stripslashes(preg_replace("#'#","&#039;",$this->form_fields[$i]['value']))."\" size=\"".$csize."\" maxlength=\"".$this->form_fields[$i]['size']."\">";
    }
    return $str;
  }

  /**************************************************************************************/
  // make the anwer array
  // private string
  function make_response(){

    for($i=0;$i<count($this->form_fields);$i++) {
      switch($this->form_fields[$i]['type']){
        case 'text':
          // Charge la valeur de la clef
          if ($this->form_fields[$i]['name']==$this->form_key) {
             $this->form_key_value=$GLOBALS[$this->form_fields[$i]['name']];
          }
        case 'password':
          if ($this->form_fields[$i]['ctrl']!="") {
             $this->control($this->form_fields[$i]['name'],$this->form_fields[$i]['en'],$GLOBALS[$this->form_fields[$i]['name']],$this->form_fields[$i]['ctrl']);
          }
          $this->answer[$i].="<TEXT>\n";
          $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$GLOBALS[$this->form_fields[$i]['name']]."</".$this->form_fields[$i]['name'].">\n";
          $this->answer[$i].="</TEXT>";
          break;

        case 'password-access':
          if ($this->form_fields[$i]['ctrl']!="") {
             $this->control($this->form_fields[$i]['name'],$this->form_fields[$i]['en'],$GLOBALS[$this->form_fields[$i]['name']],$this->form_fields[$i]['ctrl']);
          }
          $this->form_password_access=$GLOBALS[$this->form_fields[$i]['name']];
          break;

        case 'textarea':
          $this->answer[$i].="<TEXT>\n";
          $this->answer[$i].="<".$this->form_fields[$i]['name'].">".htmlspecialchars(str_replace(chr(13).chr(10),"<br />",$GLOBALS[$this->form_fields[$i]['name']]),ENT_QUOTES,'ISO-8859-1',true)."</".$this->form_fields[$i]['name'].">\n";
          $this->answer[$i].="</TEXT>";
          break;

        case 'select':
          $this->answer[$i].="<SELECT>\n";
          if( is_array($GLOBALS[$this->form_fields[$i]['name']]) ){
            for($j=0;$j<count($GLOBALS[$this->form_fields[$i]['name']]);$j++){
              $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']][$j] ]['en']."</".$this->form_fields[$i]['name'].">\n";
            }
          }else{
            $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']] ]['en']."</".$this->form_fields[$i]['name'].">";
          }
          $this->answer[$i].="</SELECT>";
          break;

        case 'radio':
          $this->answer[$i].="<RADIO>\n";
          $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']] ]['en']."</".$this->form_fields[$i]['name'].">\n";
          $this->answer[$i].="</RADIO>";
          break;

        case 'checkbox':
          $this->answer[$i].="<CHECK>\n";
          if($GLOBALS[$this->form_fields[$i]['name']]!=""){
            $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$this->form_fields[$i]['value']."</".$this->form_fields[$i]['name'].">\n";
          } else {
            $this->answer[$i].="<".$this->form_fields[$i]['name']."></".$this->form_fields[$i]['name'].">\n";
          }
          $this->answer[$i].="</CHECK>";
          break;

        case 'date':
          if ($this->form_fields[$i]['ctrl']!="") {
             $this->control($this->form_fields[$i]['name'],$this->form_fields[$i]['en'],$GLOBALS[$this->form_fields[$i]['name']],$this->form_fields[$i]['ctrl']);
          }
          if ($this->form_fields[$i]['name']==$this->form_key) {
             $this->form_key_value=$GLOBALS[$this->form_fields[$i]['name']];
          }
          $this->answer[$i].="<DATUM>\n";
          $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$GLOBALS[$this->form_fields[$i]['name']]."</".$this->form_fields[$i]['name'].">\n";
          $this->answer[$i].="</DATUM>";
          break;

        case 'stamp':
          if ($this->form_fields[$i]['name']==$this->form_key) {
             $this->form_key_value=$GLOBALS[$this->form_fields[$i]['name']];
          }
          $this->answer[$i].="<TIMESTAMP>\n";
          $this->answer[$i].="<".$this->form_fields[$i]['name'].">".$GLOBALS[$this->form_fields[$i]['name']]."</".$this->form_fields[$i]['name'].">\n";
          $this->answer[$i].="</TIMESTAMP>";
          break;

        case 'hidden':
        // Charge la valeur de la clef
          if ($this->form_fields[$i]['name']==$this->form_key) {
             $this->form_key_value=$GLOBALS[$this->form_fields[$i]['name']];
          }
        case 'submit':
        case 'reset':
        default:
          $this->answer[$i].="no_reg";
          break;
      }
    }
  }

  /**************************************************************************************/
  // Read Data structure and build a plain-text response
  function write_sform_data($response) {
   $content = "<CONTENTS>\n";
   for(Reset($response),$node=0;$node<count($response);Next($response),$node++) {
      if ($response[$node]!="no_reg") {
        $content.=$response[$node]."\n";
      }
   }
   $content .= "</CONTENTS>";
   return (addslashes($content));
  }

  /**************************************************************************************/
  // Read Data structure and build the Internal Data Structure
  function read_load_sform_data($line,$op) {
   if ((!stristr($line,"<CONTENTS>")) and (!stristr($line,"</CONTENTS>"))) {
      // Premier tag
      $nom=substr($line,1,strpos($line,">")-1);
      // jusqu'a </xxx
      $valeur=substr($line,strpos($line,">")+1,(strpos($line,"<",1)-strlen($nom)-2));
      if ($valeur=="") {$op=$nom;}
      switch($op) {
         case "TEXT":
            $op="TEXT_S";
            break;
         case "TEXT_S":
            $num=$this->interro_fields($nom);
            if ($num!="no" or $num=="0") {
               $valeur=str_replace(htmlspecialchars("<BR />",ENT_QUOTES,'ISO-8859-1',true), chr(13).chr(10), $valeur);
               $valeur=str_replace(htmlspecialchars("<br />",ENT_QUOTES,'ISO-8859-1',true), chr(13).chr(10), $valeur);
               $this->form_fields[$num]['value']=$valeur;
            }
            break;
         case "/TEXT":
            break;

         case "SELECT":
            $op="SELECT_S";
            break;
         case "SELECT_S":
            $num=$this->interro_fields($nom);
            if ($num!="no" or $num=="0") {
               $tmp=$this->interro_array($this->form_fields[$num]['value'],$valeur);
               $this->form_fields[$num]['value'][$tmp]['selected']=true;
            }
            break;
         case "/SELECT":
            break;

         case "RADIO":
            $op="RADIO_S";
            break;
         case "RADIO_S":
            $num=$this->interro_fields($nom);
            if ($num!="no" or $num=="0") {
               $tmp=$this->interro_array($this->form_fields[$num]['value'],$valeur);
               $this->form_fields[$num]['value'][$tmp]['checked']=true;
            }
            break;
         case "/RADIO":
            break;

         case "CHECK":
            $op="CHECK_S";
            break;
         case "CHECK_S":
            $num=$this->interro_fields($nom);
            if ($num!="no" or $num=="0") {
               if ($valeur) {$valeur=true;}else{$valeur=false;}
               $this->form_fields[$num]['checked']=$valeur;
            }
            break;
         case "/CHECK":
            break;

         case "TIMESTAMP":
         case "DATUM":
            $op="DATUM_S";
            break;
         case "DATUM_S":
            $num=$this->interro_fields($nom);
            if ($num!="no" or $num=="0") {
               $this->form_fields[$num]['value']=$valeur;
            }
            break;
         case "/DATUM":
            break;

         default:
            break;
      }
   }
   return ($op);
  }

  /**************************************************************************************/
  // print html response
  // $bg      => Class for TR or TD
  // $retour  => Comment for the link at the end of the page OR ="not_echo" for not 'echo' the reply but return in a string !
  // $action  => url to go
  function aff_response($bg,$retour="",$action="") {
    global $sform_path;
    //$str.="<LINK rel=\"StyleSheet\" HREF=\"".$sform_path."sform.css\" TYPE=\"text/css\">";
    $str.="<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"LIGNA\"><tr><td>";
    $str.="<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\" class=\"LIGNB\">";
    $str.="<tr class=\"LIGNA\"><td width=\"40%\" align=\"center\"><b>".$this->title."</b></td><td>&nbsp;</td></tr>";

    for($i=0;$i<count($this->form_fields);$i++){
      $num_extender=$this->interro_fields($this->form_fields[$i]['name']."extender");
      switch($this->form_fields[$i]['type']){
        case 'text':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          //$str.="<b>".stripslashes($GLOBALS[$this->form_fields[$i]['name']])."&nbsp;</b>";
          $str.="<b>".stripslashes($this->form_fields[$i]['value'])."&nbsp;</b>";
          if ($num_extender!="no") {
             $str.=" ".$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'password':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<b>".str_repeat("*", strlen($GLOBALS[$this->form_fields[$i]['name']]))."&nbsp;</b>";
          if ($num_extender!="no") {
             $str.=" ".$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'checkbox':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          if($GLOBALS[$this->form_fields[$i]['name']]!=""){
            $str.="<b>".$this->form_fields[$i]['value']."&nbsp;</b>";
          } else {
            $str.= "";
          }
          if ($num_extender!="no") {
             $str.=" ".$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'textarea':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<b>".stripslashes(str_replace(chr(13).chr(10),"<br />",$GLOBALS[$this->form_fields[$i]['name']]))."&nbsp;</b>";
          if ($num_extender!="no") {
             $str.=" ".$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'select':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          if ( is_array($GLOBALS[$this->form_fields[$i]['name']]) ){
             for ($j=0;$j<count($GLOBALS[$this->form_fields[$i]['name']]);$j++){
                $str.="<b>".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']][$j] ]['en']."&nbsp;</b><br />";
            }
          } else {
            $str.="<b>".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']] ]['en']."&nbsp;</b>";
          }
          if ($num_extender!="no") {
             $str.=" ".$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'radio':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<b>".$this->form_fields[$i]['value'][ $GLOBALS[$this->form_fields[$i]['name']] ]['en']."&nbsp;</b>";
          if ($num_extender!="no") {
             $str.=" ".$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        case 'comment':
          $str.="<tr $bg><td colspan=2>";
          $str.=$this->form_fields[$i]['en'];
          $str.="</td></tr>";
          break;

        case 'extra':
          $str.=$this->form_fields[$i]['en'];
          break;

        case 'date':
          $str.="<tr $bg><td>".$this->form_fields[$i]['en'];
          $str.="</td><td>";
          $str.="<b>".$GLOBALS[$this->form_fields[$i]['name']]."&nbsp;</b>";
          if ($num_extender!="no") {
             $str.=" ".$this->form_fields[$num_extender]['html'];
          }
          $str.="</td></tr>";
          break;

        default:
          break;
      }
    }
    if (($retour!="") and ($retour!="not_echo")) {
       $str.="<tr $bg><td colspan=\"2\" align=\"center\"><a href=\"$action\" class=\"NOIR\">[ $retour ]</a></td></tr>";
    }
    $str.="</table>";
    $str.="</td></tr></table>";

    if ($retour!="not_echo") {
       echo $str;
    } else {
       return $str;
    }
  }

  /**************************************************************************************/
  // Control the respect off Data Type
  function control($name,$nom, $valeur, $controle) {

    $i=$this->interro_fields($name);
    if (($this->form_fields[$i]['obligation']!=true) and ($valeur=="")) {
       $controle="";
    }

     switch ($controle) {
        case 'a-9':
          if (preg_match_all("/([^a-zA-Z0-9 ])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
          break;
        case 'A-9':
          if (preg_match_all("/([^A-Z0-9 ])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
          break;

        case 'email':
          $valeur = strtolower($valeur);
          if (preg_match_all("/([^a-z0-9_@.-])/i", $valeur, $trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit();
          }
          if (!preg_match("/^([a-z0-9_]|\\-|\\.)+@(([a-z0-9_]|\\-)+\\.)+[a-z]{2,4}\$/i", $valeur)) {
             $this->error($nom, "Format email invalide");
             exit ();
          }
          break;

        case '0-9':
          if (preg_match_all("/([^0-9])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
        case '0-9extend':
          if (preg_match_all("/([^0-9_\-\+\-\*\/\)\]\(\[\& ])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
          break;
        case '0-9number':
          if (preg_match_all("/([^0-9+-., ])/i", $valeur,$trouve)) {
             $this->error($nom, implode(" ",$trouve[0]));
             exit ();
          }
          break;
        case 'date':
            $date = explode("/",$valeur);
            if (!checkdate($date[1],$date[0],$date[2])) {
             $this->error($nom,"Date non valide");
             exit ();
          }

        default:
          break;
      }
  }

  /**************************************************************************************/
  function error($ibid, $car) {
    global $sform_path;
    //echo "<LINK rel=\"StyleSheet\" HREF=\"".$sform_path."sform.css\" TYPE=\"text/css\">";
    echo "<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\" class=\"LIGNA\"><tr><td>";
    echo "<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\" class=\"LIGNB\">";
    echo "<tr class=\"LIGNA\"><td>";
    //echo aff_langue($ibid)." => <span class=\"ROUGE\">".stripslashes($car)."</span><br /><br />";
    echo $ibid." => <span class=\"ROUGE\">".stripslashes($car)."</span><br /><br />";
    if ($this->form_method=="") {$this->form_method="post";}
    echo "<form action=\"".$this->url."\" method=\"".$this->form_method."\" name=\"".$this->form_title."\" enctype=\"multipart/form-data\">";
    echo $this->print_form_hidden();
    echo "&nbsp;<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"sformret\" value=\"Retour\"></form>";
    echo "</td></tr></table>";
    echo "</td></tr></table>";
  }

  /**************************************************************************************/
  // Mysql Interface
  // If the first char of $mess_ok is : ! => the button is hidden
  function sform_browse_mysql($pas,$mess_passwd,$mess_ok,$presentation='') {
     global $sform_path;
     $result=$this->db->sql_query("select key_value, passwd from ".$this->prefix."_sform where id_form='".$this->form_title."' and id_key='".$this->form_key."' ORDER BY key_value ASC");
     //echo "<LINK rel=\"StyleSheet\" HREF=\"".$sform_path."sform.css\" TYPE=\"text/css\">";
     echo "<form action=\"".$this->url."\" method=\"post\" name=\"browse\" enctype=\"multipart/form-data\">";
     echo "<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\" class=\"LIGNA\"><tr><td>";
     echo "<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"1\" class=\"LIGNB\">";
     $hidden=false;
     if (substr($mess_ok,0,1)=="!") {
        $mess_ok=substr($mess_ok,1);
        $hidden=true;
     }
     $ibid=0;
     while (list($key_value, $passwd) = $this->db->sql_fetchrow($result)) {
        if ($ibid==0) {
           echo "<tr class=\"LIGNA\">";
        }
        $ibid++;
        if ($passwd!="") {$red="<span class=\"ROUGE\">$key_value (v)</span>";}else{$red="$key_value";}
        if ($presentation=="liste") {
           echo "<td><a href=\"".$this->url."&amp;".$this->submit_value."=$mess_ok&amp;browse_key=".urlencode($key_value)."\" class=\"NOIR\">$key_value</a></td>";
        } else {
           echo "<td><input type=\"radio\" name=\"browse_key\" value=\"".urlencode($key_value)."\"> $red</td>";
        }
        if ($ibid>=$pas) {
           echo "</tr>";
           $ibid=0;
        }
     }
     echo "</table><br />";
     if ($this->form_password_access!="") {
        echo "$mess_passwd : <input class=\"TEXTBOX_STANDARD\" type=\"password\" name=\"password\" value=\"\"> - ";
     }
     if (!$hidden) {
        echo "<input class=\"BOUTON_STANDARD\" type=\"submit\" name=\"".$this->submit_value."\" value=\"$mess_ok\">";
     }
     echo "</td></tr></table></form>";
  }

  /**************************************************************************************/
  function sform_read_mysql($clef) {
     if ($clef!="") {
        $clef=urldecode($clef);
        //$result=$this->db->sql_query("select content from ".$this->prefix."_sform where id_form='".$this->form_title."' and id_key='".$this->form_key."' and key_value='".addslashes($clef)."' and passwd='".$this->form_password_access."' ORDER BY key_value ASC");
         $result=$this->db->sql_query("select content from ".$this->prefix."_sform where id_form='".$this->form_title."' and id_key='".$this->form_key."' and key_value='".addslashes($clef)."' ORDER BY key_value ASC");
         if (!$result) {
        	echo "Prefix :$this->prefix<br>";
        	echo "Title: $this->form_title<br>";
			echo "Key :$this->form_key <br>";
			echo "Cle :". addslashes($clef)."</br>";
			echo "Pass : $this->form_password_access <br><br>";
        	die('Invalid query (sform_Read):'.$this->db->sql_error());
         }


        $tmp = $this->db->sql_fetchrow($result);
        if ($tmp) {
           $ibid=explode("\n",$tmp['content']);
           while (list($num,$line)=each($ibid)) {
              $op=$this->read_load_sform_data(stripslashes($line),$op);
           }
           return(true);
        } else {
           return(false);
        }
     }
  }

  /**************************************************************************************/
  function sform_insert_mysql($response) {
     $content=$this->write_sform_data($response);
     $sql = "INSERT INTO ".$this->prefix."_sform (id_form, id_key, key_value, passwd, content) ";
     $sql .= "VALUES ('".$this->form_title."', '".$this->form_key."', '".$this->form_key_value."', '".$this->form_password_access."', '$content')";
     if (!$result = $this->db->sql_query($sql)) {
        //return ("Error Sform : Insert DB");
        	die('Invalid query (dataSavePin Update):'.$this->db->sql_error());

     }
  }

  /**************************************************************************************/
  function sform_delete_mysql() {
     $sql = "DELETE FROM ".$this->prefix."_sform WHERE id_form='".$this->form_title."' and id_key='".$this->form_key."' and key_value='".$this->form_key_value."'";
     if (!$result = $this->db->sql_query($sql)) {
        return ("Error Sform : Delete DB");
     }
  }

  /**************************************************************************************/
  function sform_modify_mysql($response) {
     $content=$this->write_sform_data($response);
     $sql = "UPDATE ".$this->prefix."_sform SET passwd='".$this->form_password_access."', content='$content' WHERE (id_form='".$this->form_title."' and id_key='".$this->form_key."' and key_value='".$this->form_key_value."')";
     if (!$result = $this->db->sql_query($sql)) {
        return ("Error Sform : Update DB");
     }
  }

  /**************************************************************************************/
  function sform_read_mysql_XML($clef) {
    if ($clef!="") {
        $clef=urldecode($clef);
        $result=$this->db->sql_query("select content from ".$this->prefix."_sform where id_form='".$this->form_title."' and id_key='".$this->form_key."' and key_value='$clef' and passwd='".$this->form_password_access."' ORDER BY key_value ASC");
        $tmp = $this->db->sql_fetchrow($result);

        $analyseur_xml = xml_parser_create();

        xml_parser_set_option($analyseur_xml,XML_OPTION_CASE_FOLDING,0);
        xml_parse_into_struct($analyseur_xml,$tmp[content],$value,$tag);

        $this->sform_XML_tag($value);

        xml_parser_free($analyseur_xml);
        return(true);
    }   else return(false);
  }

/**
 * set_form_name
 * Set Form name
 * @param string form name
 */
function set_form_name($dynform_name){
	$this->form_name=$dynform_name;
}
/**
 * set_form_author
 * Set Form author
 * @param string form name
 */
function set_form_author($dynform_author){
	$this->form_name=$dynform_author;
}
/**
 * set_form_description
 * Set Form author
 * @param string form name
 */
function set_form_description($dynform_description){
	$this->form_name=$dynform_description;
}

/**
 * set db
 * set db handler. Could be useful when object is serialised complexe data will not be save
 * @param database handler
 */
function set_db($db){
	$this->db=$db;
}

  /**
   * sform_save_form()
   *
   */
  function sform_save_form(){

  	$xmlDoc = new MiniXMLDoc();

    if ($this->form_description=="") $this->form_description=$this->mess;
    if ($this->form_name=="") $this->form_name=$this->form_title;

    $formArray=Array("Form"=>$this->form_fields);

  	$xmlDoc->fromArray($formArray);
	$new=false;
  	$stringform=$xmlDoc->toString();
    if ($this->form_id=="") {
  	$sql = "INSERT INTO ".$this->prefix."_dynform (dynform_name, dynform_description, dynform_content, dynform_date, dynform_author) ";
    $sql .= "VALUES ('".$this->form_name."', '".$this->form_description."', '".$stringform."', now(), '".$this->form_author."')";
    $new=true;
    } else {
    $sql = "UPDATE ".$this->prefix."_dynform SET dynform_name='".$this->form_name."', dynform_description='".$this->form_description."', dynform_content='$stringform' WHERE dynform_id='".$this->form_id."'";
    }
    if (!$result = $this->db->sql_query($sql)) {
        //return ("Error Sform : Update DB when Add form : ".$this->db->sql_error);
    	die('Invalid query:'.$this->db->sql_error()."<br>$sql");
     }
    if ($new) $this->form_id=$this->db->sql_nextid(); // must be changed to no dependent db api
    return(true);
  }
  /**
   * sform_read_form()
   *
   */
  function sform_read_form($formid){

  	$sql="select dynform_name, dynform_description, dynform_content, dynform_author from ".$this->prefix."_dynform where dynform_id='$formid'";
  	if (!$result = $this->db->sql_query($sql)) {
        //return ("Error Sform : Read DB when Read form");
        die('Invalid query:'.$this->db->sql_error());
     } else {
  	list($dynform_name, $dynform_description, $content, $dynform_author)=$this->db->sql_fetchrow($result);
  	$xmlDoc = new MiniXMLDoc();
  	$xmlDoc->fromString($content);
  	$formAsArray=$xmlDoc->toArray();

	//echo "<pre>";
	//echo "<br>Content :$content";
  	//echo "<br>Form ID : $formid<br>";
	//print_r($formAsArray);
    if (isset($formAsArray["Form"]["name"])) {
  	$this->form_fields=Array($formAsArray["Form"]);
  	//echo "Count Case One: ".count($formAsArray["Form"]);

    } else {
  	$this->form_fields=$formAsArray["Form"];
  	//echo "Count Case Two: ".count($formAsArray["Form"]);
  	//echo "Count Case Two: ".count($formAsArray);
    }
  	$this->form_id=$formid;
  	$this->form_name=$dynform_name;
  	$this->form_description=$dynform_description;
  	$this->form_author=$dynform_author;
  	//print_r($this->form_fields);
  	//echo "</pre>";
  	return(true);
  	}
  }
  /**
   * sform_modify_form()
   *
   */
  function sform_modify_form($formid){
  	$xmlDoc = new MiniXMLDoc();
  	$xmlDoc->fromArray($this->form_fields);
  }

  /**************************************************************************************/
  function sform_XML_tag($value) {
    foreach ($value as $num=>$val) {
       if ($val[type]=='complete') { // open, complete, close
          $nom    = $val[tag];       // Le nom du tag
          $valeur = $val[value];     // La valeur du champs
          $idchamp= $this->interro_fields($nom);

          switch ( $value[$num-1][tag] ) {
              case "TEXT":
                   $valeur=str_replace(htmlspecialchars("<BR />",ENT_QUOTES,'ISO-8859-1',true), chr(13).chr(10), $valeur);
                   $valeur=str_replace(htmlspecialchars("<br />",ENT_QUOTES,'ISO-8859-1',true), chr(13).chr(10), $valeur);
                   $this->form_fields[$idchamp]['value']=$valeur;
                   break;
              case "SELECT":
                   $tmp=$this->interro_array($this->form_fields[$idchamp]['value'],$valeur);
                   $this->form_fields[$idchamp]['value'][$tmp]['selected']=true;
              break;
              case "RADIO":
                   $tmp=$this->interro_array($this->form_fields[$idchamp]['value'],$valeur);
                   $this->form_fields[$idchamp]['value'][$tmp]['checked']=true;
              break;
              case "CHECK":
                   if ($valeur) {$valeur=true;}else{$valeur=false;}
                   $this->form_fields[$idchamp]['checked']=$valeur;
              break;
              case "DATUM":
                   $this->form_fields[$idchamp]['value']=$valeur;
              break;
              case "TIMESTAMP":
                   $this->form_fields[$idchamp]['value']=$valeur;
              break;
          }
       }
    }
  }

}
?>