<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* Enhanced with PHP-NUKE                                               */
/* =======================                                              */
/* Copyright (c) 2002 by Francisco Burzi (fbc@mandrakesoft.com)         */
/* http://phpnuke.org                                                   */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/
//error_reporting(~E_ALL);

function mon_addslashes($valeur) {
	if(is_array($valeur)) {
		foreach ($valeur as $key=>$value) {
			$valeur[$key] = mon_addslashes($value);
		}
	} else {
		$valeur = addslashes($valeur);
	}
	return $valeur;
}

function mon_utf8_decode($valeur) {
	if(is_array($valeur)) {
		foreach ($valeur as $key=>$value) {
			$valeur[$key] = mon_utf8_decode($value);
		}
	} else {
		$valeur = utf8_decode($valeur);
	}
	return $valeur;
}
/**
 * Mainfile. It's the main library of the framework
 */
//secutity hole
foreach ($_REQUEST as $key=>$value) {
	if (get_magic_quotes_gpc()==0) {
		$value = mon_addslashes($value); // This will reproduce the option magic_quotes_gpc=1
	} // becarefull if magic_quote_gpc is Off, this code create an issue with multiple option
	// with form select object. name="var[]" return always word Array as value instead of an Array
	$value = str_replace(array(')','=','<','>','|'),array(')','=','<','>','|'),$value);
	${$key} = $value;
	$_REQUEST[$key] = $value;
	if (isset($_POST[$key])) { $_POST[$key] = $value; }
	if (isset($_COOKIE[$key])) { $_COOKIE[$key] = $value; }
	if (isset($_FILE[$key])) { $_FILE[$key] = $value; }
	if (isset($_GET[$key])) { 
		// utf8_decode car le passage en GET encode toutes les valeurs en utf8.
		$value1 = mon_utf8_decode($value);
		$_GET[$key] = $value1;
		${$key} = $value1;
		$_REQUEST[$key] = $value1;
	}
	if (isset($HTTP_POST_VARS[$key])) { $HTTP_POST_VARS[$key] = $value;}
	if (isset($HTTP_COOKIE_VARS[$key])) { $HTTP_COOKIE_VARS[$key] = $value;}
	if (isset($HTTP_FILE_VARS[$key])) { $HTTP_FILE_VARS[$key] = $value;}
	if (isset($HTTP_GET_VARS[$key])) { $HTTP_GET_VARS[$key] = $value; }
}

foreach ($_COOKIE as $key=>$value) {
	${$key} = $value;
}

// security hole
foreach ($_GET as $secvalue) {
	if (is_array($secvalue)) {
		foreach ($secvalue as $thevalue) {
			if (preg_match("#<[^>]*script*\"?[^>]*>#i", $thevalue)) {
				die ("I don't like you...");
			}
		}
	}
	else {
		if (preg_match("#<[^>]*script*\"?[^>]*>#i", $secvalue)) {
			die ("I don't like you...");
		}
	}
}
// This block of code makes sure $admin and $user are COOKIES
if((isset($admin) && $admin != $_COOKIE['admin']) OR (isset($user) && $user != $_COOKIE['user'])) {
	die(" !!  Illegal Operation !!");
}
// ------------------------ compression ----------------------------
if (strstr($_SERVER['HTTP_ACCEPT_ENCODING'], 'gzip')) {
	if (extension_loaded('zlib')) {
		$do_gzip_compress = true;
		ob_start('ob_gzhandler');
		//ob_start(array('ob_gzhandler', '5'));
		ob_implicit_flush(0);
		if (preg_match("#MSIE#", $_SERVER['HTTP_USER_AGENT'])) {
			header('Content-Encoding: gzip');
		}
	}
}
else {
	ob_start();
}
$PHP_SELF= $_SERVER['PHP_SELF'];
if (preg_match("#becms_mainlib_lib.php#i",$_SERVER['PHP_SELF'])) {
	Header("Location: index.php");
	die();
}
//Union Tap
//Copyright Zhen-Xjell 2004 http://nukecops.com
//Beta 3 Code to prevent UNION SQL Injections
unset($matches);
unset($loc);
if(isset($_SERVER['QUERY_STRING'])) {
	if (preg_match("/([OdWo5NIbpuU4V2iJT0n]{5}) /", rawurldecode($loc=$_SERVER['QUERY_STRING']), $matches)) {
		die('!! Illegal Operation !!');
	}
}

// This block of code makes sure $admin and $user are COOKIES
if((isset($admin) && $admin != $_COOKIE['admin']) OR (isset($user) && $user != $_COOKIE['user'])) {
	die("!! Illegal Operation !!");
}

// Additional security (Union, CLike, XSS)
if(!file_exists('includes/nukesentinel.php')) {
	if(isset($_SERVER['QUERY_STRING']) && (!stripos_clone($_SERVER['QUERY_STRING'], "ad_click") || !stripos_clone($_SERVER['QUERY_STRING'], "url"))) {
		$queryString = $_SERVER['QUERY_STRING'];
		if (stripos_clone($queryString,'%20union%20') OR stripos_clone($queryString,'/*') OR stripos_clone($queryString,'*/union/*') OR stripos_clone($queryString,'c2nyaxb0') OR stripos_clone($queryString,'+union+') OR stripos_clone($queryString,'http://') OR (stripos_clone($queryString,'cmd=') AND !stripos_clone($queryString,'&cmd')) OR (stripos_clone($queryString,'exec') AND !stripos_clone($queryString,'execu')) OR stripos_clone($queryString,'concat')) {
			die('!! Illegal Operation !!');
		}
	}
}

$postString = "";
foreach ($_POST as $postkey => $postvalue) {
	if ($postString > "") {
		$postString .= "&".$postkey."=".$postvalue;
	} else {
		$postString .= $postkey."=".$postvalue;
	}
}
str_replace("%09", "%20", $postString);
$postString_64 = base64_decode($postString);
if (stripos_clone($postString,'%20union%20') OR stripos_clone($postString,'*/union/*') OR stripos_clone($postString,' union ') OR stripos_clone($postString_64,'%20union%20') OR stripos_clone($postString_64,'*/union/*') OR stripos_clone($postString_64,' union ') OR stripos_clone($postString_64,'+union+')) {
	header("Location: index.php");
	die();
}

if(isset($admin))
{
	$admin = base64_decode($admin);
	$admin = addslashes($admin);
	$admin = base64_encode($admin);
}

if(isset($user))
{
	$user = base64_decode($user);
	$user = addslashes($user);
	$user = base64_encode($user);
}

// Posting from other servers in not allowed
// Fix by Quake
// Bug found by PeNdEjO
if ($_SERVER['REQUEST_METHOD'] == "POST") {
	if (isset($_SERVER['HTTP_REFERER'])) {
		if (!stripos_clone($_SERVER['HTTP_REFERER'], $_SERVER['HTTP_HOST'])) {
			die('Posting from another server not allowed!');
		}
	} else {
	    if ($_POST["op"] != "send_app_obs_aliem" && $_GET["op"] != "send_app_obs_aliem") {
	        die($posttags);
	    }
	}
}

@require_once("config.php");
/*************************************************/
/* ici on met en route un petit systme de cache */
/*************************************************/
/* Ce systme est  valider en particulier avec les flux dont il faut maitriser le type : RSS, XML, JSON, ... */
/* liste des enttes  mmoriser headers_list();*/
if ($globalcache && (preg_match("#modules.php#", $_SERVER["SCRIPT_NAME"]) || preg_match("#mobiles.php#", $_SERVER["SCRIPT_NAME"]))) {
	$chemin = "cache";
	if (!file_exists($chemin)) {
		if (!mkdir($chemin,0777,true)) {
			die("Impossible de crer le dossier de destination de l'upload !");
		}
		touch($chemin."/index.htm");
	}
	global $pageducache;
	
	$pageducache=$chemin."/".md5($_SERVER["HTTP_HOST"].$_SERVER["REQUEST_URI"]."&".$postString);
	if (file_exists($pageducache)) {
		if (file_exists($pageducache."_h")) {
			$mes_headers = unserialize(file_get_contents($pageducache."_h"));
			foreach ($mes_headers as $unheader) {
				if (!preg_match("#X-Powered-By#", $unheader)) {
					header($unheader);
				}
			}
		}
		if (!readfile($pageducache)){
			die("erreur du cache");
		}
		else {
			//echo "cache !";
			die();
		}
	}
}
/* fin du systme de cache */

@require_once("core/db/db.php");
@require_once("core/becms_checkbrowser_class.php");
@require_once("core/becms_logger_class.php");

$tracepath="logs/baliste.log";
$istrace=true;
if ($istrace){
	$trace=new logger($tracepath);
} else {
	$trace=new loggerOff();
}
$browser= new checkBrowser;
if ($browser->getPlateform()=="Linux Embedix")
{
	$Default_Theme = "ZaurusBaliste";
}

define('BECMS_FILE', true);

$mainfile = 1;
$admin_file="system"; // phpnuke 7.9 compatibilities
if (isset($newlang)) {
	if (file_exists("language/lang-$newlang.php")) {
		setcookie("lang",$newlang,time()+31536000);
		include("language/lang-$newlang.php");
		$currentlang = $newlang;
	} else {
		setcookie("lang",$language,time()+31536000);
		include("language/lang-$language.php");
		$currentlang = $language;
	}
} elseif (isset($lang)) {
	include("language/lang-$lang.php");
	$currentlang = $lang;
} else {
	setcookie("lang",$language,time()+31536000);
	include("language/lang-$language.php");
	$currentlang = $language;
}

global $locale;
switch ($currentlang) {
	case "italian" :
		$locale = str_replace("fr_FR", "it_IT", $locale);
		break;
	case "english" :
		$locale = str_replace("fr_FR", "en_US", $locale);
		break;
	case "spanish" :
		$locale = str_replace("fr_FR", "es_ES", $locale);
		break;
	case "german" :
		$locale = str_replace("fr_FR", "de_DE", $locale);
		break;
}

// check login
checklogin();
// add header
$_headerContent=NULL;

// --------------------- Star methode librarie ----------------------
/**
 * checklogin
 * if default login challenge is setting on true, display login page.
 * that mean that all users must be logged
 * @return
 * @see $anonymouslogin variable
 * @author Stephan Acquatella
 */
function checklogin(){
	global $anonymouslogin, $user, $admin;
	if (!isset($anonymouslogin)) $anonymouslogin=0;
	if (!($anonymouslogin) && !(is_user($user) || is_admin($admin)) ) {
		Header("Location: login.php");
	}
}
/**
 * get_lang ()
 * @param $module
 */
function get_lang($module) {
	global $currentlang;
	global $Default_Theme;
	
	if ($module == "admin") {
			
	 if (file_exists("system/language/lang-$currentlang.php")) {
	 	include_once("system/language/lang-$currentlang.php");
		}
	} else {
		// added by Baliste. Check if language with images exist
		if (file_exists("themes/$Default_Theme/language/lang-$currentlang.php")) {
			include_once("themes/$Default_Theme/language/lang-$currentlang.php");
		} else if (file_exists("modules/$module/language/lang-$currentlang.php")) {
			include_once("modules/$module/language/lang-$currentlang.php");
		}
	}
}
/**
 * is_admin()
 * @param $admin
 *
 */
function is_admin($admin) {
	global $prefix, $db;
	if(!is_array($admin)) {
		$admin = base64_decode($admin);
		$admin = explode(":", $admin);
		$aid = "$admin[0]";
		$pwd = "$admin[1]";
	} else {
		$aid = "$admin[0]";
		$pwd = "$admin[1]";
	}
	$result = $db->sql_query("select pwd from ".$prefix."_authors where aid='$aid'");
	list($pass) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	if($pass == $pwd && $pass != "") {
		return 1;
	}
	return 0;
}

function is_super($admin) {
	global $prefix, $db;;
	if(!is_array($admin)) {
		$admin = base64_decode($admin);
		$admin = explode(":", $admin);
		$aid = "$admin[0]";
		$pwd = "$admin[1]";
	} else {
		$aid = "$admin[0]";
		$pwd = "$admin[1]";
	}
	$result = $db->sql_query("select pwd,radminsuper from ".$prefix."_authors where aid='$aid'");
	list($pass,$radminsuper) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	if($pass == $pwd && $pass != "" && $radminsuper=="1") {
		return 1;
	}
	return 0;
}

function is_current($admin,$name) {
	global $prefix, $db;
	if(!is_array($admin)) {
		$admin = base64_decode($admin);
		$admin = explode(":", $admin);
		$aid = "$admin[0]";
		$pwd = "$admin[1]";
	} else {
		$aid = "$admin[0]";
		$pwd = "$admin[1]";
	}
	$result = $db->sql_query("select name,pwd from ".$prefix."_authors where aid='$aid'");
	list($lename,$pass) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	if($pass == $pwd && $pass != "" && $name == $lename) {
		return 1;
	}
	return 0;
}

function is_user($user) {
	global $prefix, $db, $user_prefix;
	if(!is_array($user)) {
		$user = base64_decode($user);
		$user = explode(":", $user);
		$uid = "$user[0]";
		$pwd = "$user[2]";
	}
	else {
		$uid = "$user[0]";
		$pwd = "$user[2]";
	}
	$result = $db->sql_query("select pass from ".$user_prefix."_users where uid='$uid'");
	list($pass) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	if($pass == $pwd && $pass != "") {
		return 1;
	}
	return 0;
}

function title($text) {
	//OpenSysTable();
	echo "<center><font class=\"title\"><b>$text</b></font></center>";
	//CloseSysTable();
	echo "<br>";
}

function is_active($module) {
	global $prefix, $db;
	$result = $db->sql_query("select active from ".$prefix."_modules where title='$module'");
	list ($act) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	if (!$result OR $act == 0) {
		return 0;
	} else {
		return 1;
	}
}

function render_blocks($side, $blockfile, $title, $content, $bid, $url) {
	if ($url == "") {
		if ($blockfile == "") {
			if ($side == "c") {
				themecenterbox($title, $content);
			} else {
				themesidebox($title, $content);
			}
		} else {
			if ($side == "c") {
				blockfileinc($title, $blockfile, 1);
			} else {
				blockfileinc($title, $blockfile);
			}
		}
	} else {
		if ($side == "c") {
			headlines($bid,1);
		} else {
			headlines($bid);
		}
	}
}

function blocks($side) {
	global $storynum, $prefix, $multilingual, $currentlang, $db, $admin, $user;
	if ($multilingual == 1) {
		$querylang = "AND (blanguage='$currentlang' OR blanguage='')";
	} else {
		$querylang = "";
	}
	if (strtolower($side[0]) == "l") {
		$pos = "l";
	} elseif (strtolower($side[0]) == "r") {
		$pos = "r";
	}  elseif (strtolower($side[0]) == "c") {
		$pos = "c";
	}
	$side = $pos;
	$result = $db->sql_query("select bid, bkey, title, content, url, blockfile, view from ".$prefix."_blocks where position='$pos' AND active='1' $querylang ORDER BY weight ASC");
	while(list($bid, $bkey, $title, $content, $url, $blockfile, $view) = $db->sql_fetchrow($result)) {
		if ($bkey == admin) {
			adminblock();
		} elseif ($bkey == userbox) {
			userblock();
		} elseif ($bkey == "") {
			if ($view == 0) {
				render_blocks($side, $blockfile, $title, $content, $bid, $url);
			} elseif ($view == 1 AND is_user($user) || is_admin($admin)) {
				render_blocks($side, $blockfile, $title, $content, $bid, $url);
			} elseif ($view == 2 AND is_admin($admin)) {
				render_blocks($side, $blockfile, $title, $content, $bid, $url);
			} elseif ($view == 3 AND !is_user($user) || is_admin($admin)) {
				render_blocks($side, $blockfile, $title, $content, $bid, $url);
			}
		}
	}
	$db->sql_freeresult($result);
}

/**
 * insert_video_player()
 * remplace l'image de preview d'une vido par la vido elle mme
 */
function insert_video_player($letexte, $ismobile = false) {
	if (preg_match_all("/<img[^>]+type=\"mediaplayer\"[^>]*>/im", $letexte,$tabimages, PREG_PATTERN_ORDER)) {
		foreach ($tabimages[0] as $tabimage) {
			if ($ismobile) {
				$letexte = str_replace($tabimage, "", $letexte);
			}
			else {
				if (preg_match("/<img ([^>]*)video=\"([^\"]*)\"([^>]*)>/i", $tabimage, $tabval) != 0) {
					$videoflash = $tabval[2];
				}
				if (preg_match("/<img([^>]*)src=\"([^\"]*)\"([^>]*)>/i", $tabimage, $tabval) != 0) {
					$imageflash = $tabval[2];
				}
				if (preg_match("/<img([^>]*)height=\"([^\"]*)\"([^>]*)>/i", $tabimage, $tabval) != 0) {
					$heightflash = $tabval[2];
				}
				if (preg_match("/<img([^>]*)height: ([0-9]+)([^>]*)>/i", $tabimage, $tabval) != 0) {
					$heightflash = $tabval[2];
				}
				if (preg_match("/<img([^>]*)width=\"([^\"]*)\"([^>]*)>/i", $tabimage, $tabval) != 0) {
					$widthflash = $tabval[2];
				}
				if (preg_match("/<img([^>]*)width: ([0-9]+)([^>]*)>/i", $tabimage, $tabval) != 0) {
					$widthflash = $tabval[2];
				}
				$leplayerflash = '<object id="player" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" name="player" width="'.$widthflash.'" height="'.$heightflash.'">'
							.'<param name="movie" value="flash/mediaplayer/player.swf" />'
							.'<param name="allowfullscreen" value="true" />'
							.'<param name="allowscriptaccess" value="always" />'
							//.'<param name="flashvars" value="file='.$videoflash.'&amp;image='.$imageflash.'&amp;logo=flash/mediaplayer/logo.png" />'
							.'<param name="flashvars" value="file='.$videoflash.'&amp;image='.$imageflash.'" />'
							.'<object type="application/x-shockwave-flash" data="flash/mediaplayer/player.swf" width="'.$widthflash.'" height="'.$heightflash.'">'
							.'<param name="movie" value="flash/mediaplayer/player.swf" />'
							.'<param name="allowfullscreen" value="true" />'
							.'<param name="allowscriptaccess" value="always" />'
							//.'<param name="flashvars" value="file='.$videoflash.'&amp;image='.$imageflash.'&amp;logo=flash/mediaplayer/logo.png" />'
							.'<param name="flashvars" value="file='.$videoflash.'&amp;image='.$imageflash.'" />'
							.'<p><a href="http://get.adobe.com/flashplayer">Vido en cours de chargement</p>'
							.'</object>'
							.'</object>';
				//$letexte = preg_replace("#<img ([^>]*)type=\"mediaplayer\"([^>]*)>#i",$leplayerflash, $letexte);
				//$tabimage = str_replace(".","\\\\.",$tabimage);
				//$letexte = preg_replace("/$tabimage/im",$leplayerflash, $letexte, 1);
				$nbre = 1;
				$letexte = str_replace($tabimage, $leplayerflash, $letexte,$nbre);
			}
		}
	}
	if (preg_match_all("/<img[^>]+type=\"youtubeplayer\"[^>]*>/im", $letexte,$tabimages, PREG_PATTERN_ORDER)) {
		foreach ($tabimages[0] as $tabimage) {
			if (preg_match("/<img ([^>]*)video=\"([^\"]*)\"([^>]*)>/i", $tabimage, $tabval) != 0) {
				$videoyoutube = $tabval[2];
			}
			if (preg_match("/<img([^>]*)src=\"([^\"]*)\"([^>]*)>/i", $tabimage, $tabval) != 0) {
				$imageyoutube = $tabval[2];
			}
			if (preg_match("/<img([^>]*)height=\"([^\"]*)\"([^>]*)>/i", $tabimage, $tabval) != 0) {
				$heightyoutube = $tabval[2];
			}
			if (preg_match("/<img([^>]*)height: ([0-9]+)([^>]*)>/i", $tabimage, $tabval) != 0) {
				$heightyoutube = $tabval[2];
			}
			if (preg_match("/<img([^>]*)width=\"([^\"]*)\"([^>]*)>/i", $tabimage, $tabval) != 0) {
				$widthyoutube = $tabval[2];
			}
			if (preg_match("/<img([^>]*)width: ([0-9]+)([^>]*)>/i", $tabimage, $tabval) != 0) {
				$widthyoutube = $tabval[2];
			}
			/**
			 * autoplay : Demarrage automatique de la vido (1 elle se lance, 0 non)
			 * autohide : cacher la barre du player (1 elle se cache au bout de 1s, 0 non)
			 * controls : pas de controle de player (0 pas de controle, 1 sinon)
			 * fs : Permet de bloquer le plein cran (0 pas de plein cran, 1 sinon)
			 * modestbranding : 1 enlve le logo YouTube dans la barre du player, 0 sinon
			 * rel : 0 ne pas faire apparaitre les vignttes des vidos a la fin, 1 sinon
			 * showinfo : 0 n'affiche pas les infos de la vido (titre, ...), 1 sinon
			 * start : faire commenc la vido au temps voulu (start=5 pour qu'elle demarre a 5s)
			 * Theme : theme=light pour une barre grise ou theme=dark pour une barre noire.
			 */
			$pleplayeryoutube = '<iframe width="'.$widthyoutube.'"
							height="'.$heightyoutube.'" src="https://www.youtube.com/embed/'.$videoyoutube.'?autoplay=0&rel=0&showinfo=0" 
							frameborder="0" allowfullscreen></iframe>';
			$nbre = 1;
			$letexte = str_replace($tabimage, $pleplayeryoutube, $letexte,$nbre);
		}
	}
	/*while (preg_match("/type=\"mediaplayer\"/i", $letexte)) {
		if (preg_match("/<img ([^>]*)video=\"([^\"]*)\"([^>]*)>/i", $letexte, $tabval) !== false) {
			$videoflash = $tabval[2];
		}
		if (preg_match("/<img ([^>]*)src=\"([^\"]*)\"([^>]*)>/i", $letexte, $tabval) !== false) {
			$imageflash = $tabval[2];
		}
		if (preg_match("/<img ([^>]*)height=\"([^\"]*)\"([^>]*)>/i", $letexte, $tabval) !== false) {
			$heightflash = $tabval[2];
		}
		if (preg_match("/<img ([^>]*)width=\"([^\"]*)\"([^>]*)>/i", $letexte, $tabval) !== false) {
			$widthflash = $tabval[2];
		}
		$leplayerflash = '<object id="player" classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" name="player" width="'.$widthflash.'" height="'.$heightflash.'">'
						.'<param name="movie" value="flash/mediaplayer/player.swf" />'
						.'<param name="allowfullscreen" value="true" />'
						.'<param name="allowscriptaccess" value="always" />'
						//.'<param name="flashvars" value="file='.$videoflash.'&amp;image='.$imageflash.'&amp;logo=flash/mediaplayer/logo.png" />'
						.'<param name="flashvars" value="file='.$videoflash.'&amp;image='.$imageflash.'" />'
						.'<object type="application/x-shockwave-flash" data="flash/mediaplayer/player.swf" width="'.$widthflash.'" height="'.$heightflash.'">'
						.'<param name="movie" value="flash/mediaplayer/player.swf" />'
						.'<param name="allowfullscreen" value="true" />'
						.'<param name="allowscriptaccess" value="always" />'
						//.'<param name="flashvars" value="file='.$videoflash.'&amp;image='.$imageflash.'&amp;logo=flash/mediaplayer/logo.png" />'
						.'<param name="flashvars" value="file='.$videoflash.'&amp;image='.$imageflash.'" />'
						.'<p><a href="http://get.adobe.com/flashplayer">Vido en cours de chargement</p>'
						.'</object>'
						.'</object>';
		//$letexte = preg_replace("#<img ([^>]*)type=\"mediaplayer\"([^>]*)>#i",$leplayerflash, $letexte);
		$letexte = preg_replace("/<img ([^>]*)type=\"mediaplayer\"([^>]*)>/i",$leplayerflash, $letexte, 1);
	}*/
	return $letexte;
}

function insert_simple_map($letexte, $ismobile = false) {
	global $Default_Theme, $cartobuttons, $cartopictowidth, $cartopictoheight, $cartopleinecran, $cartopospicto;
	//le preg_match_all ne sert  rien pour l'instant : une seule carte peut tre affiche  la fois... 
	if (preg_match_all("/<img[^>]+type=\"googlemap\"[^>]*>/im", $letexte, $tabcartes, PREG_PATTERN_ORDER)) {
		foreach ($tabcartes[0] as $tabcarte) {
			if (preg_match("/<img ([^>]*)map=\"([^\"]*)\"([^>]*)>/i", $tabcarte, $tabval) != 0) {
				$idmap = $tabval[2];
			}
			//style="width: 486px; height: 663px;"
			$heightmap = "";
			if (preg_match("/<img([^>]*)height=\"([^\"]*)\"([^>]*)>/i", $tabcarte, $tabval) != 0) {
				$heightmap = $tabval[2];
			}
			if (preg_match("/<img([^>]*)height: ([0-9]+)([^>]*)>/i", $tabcarte, $tabval) != 0) {
				$heightmap = $tabval[2];
			}
			$widthmap = "";
			if (preg_match("/<img([^>]*)width=\"([^\"]*)\"([^>]*)>/i", $tabcarte, $tabval) != 0) {
				$widthmap = $tabval[2];
			}
			if (preg_match("/<img([^>]*)width: ([0-9]+)([^>]*)>/i", $tabcarte, $tabval) != 0) {
				$widthmap = $tabval[2];
			}
			if (file_exists("themes/$Default_Theme/style/SimpleCarto.css")) {
				$style = '<link href="themes/'.$Default_Theme.'/style/SimpleCarto.css" rel="stylesheet" type="text/css" media="all"/>';
			}
			else {
				$style = '<link href="modules/SimpleCarto/lib/style-map.css" rel="stylesheet" type="text/css" media="all"/>';
			}
			//$lamap = '[map/'.$idmap.'/'.$widthmap.'/'.$heightmap.']';
			
			if ($ismobile) {
				$tailleforcee = '';
				$styleMap = '';
				if ($widthmap != "" && $heightmap != "") {
					$tailleforcee = $widthmap.'/'.$heightmap;
					$styleMap = ' style="width: '.$widthmap.'px; height:'.$heightmap.'px"';
				}
				$scriptcarto = "getscript_display_mobile.php";
				require_once("modules/SimpleCarto/lib/g_params.php");
				$lamap = '<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?key='.$keymap.'&sensor=false" charset="UTF-8"></script>
					    <script type="text/javascript" src="modules/SimpleCarto/lib/'.$scriptcarto.'"  charset="UTF-8"></script>
						<script type="text/javascript">
						//<![CDATA[
						var options = new Array;';
							$btns = "";
							foreach ($cartobuttons as $typedemap) {
								$btns .= ($btns == "") ? "" : ",";
								$btns .= $typedemap;
							}
							$lamap .= '
						//options["btnstypes"] = ['.$btns.'];';
						$lamap .= "\n".'options["anchor_picto"] = "'.$cartopospicto.'";';
						$lamap .= "\n".'options["width_picto"] = '.$cartopictowidth.';';
						$lamap .= "\n".'options["height_picto"] = '.$cartopictoheight.';';
							$lamap .= '
						var racine_lib_module = "modules/SimpleCarto/lib";
					    //]]>
					    </script>
					    <script type="text/javascript">
						// <![CDATA[
							addToStart("GetMap(\''.$idmap.'\', \''.$tailleforcee.'\')");
							//addToStop(GUnload);
						// ]]>
						</script>
					    	'.$style.'
						<div id="map"'.$styleMap.'></div>';
			}
			else {
				$tailleforcee = '';
				$styleMap = '';
				if ($widthmap != "" && $heightmap != "") {
					$tailleforcee = $widthmap.'/'.$heightmap;
					$styleMap = ' style="width: '.$widthmap.'px; height:'.$heightmap.'px"';
				}
				$scriptcarto = "getscript_display.php";
				require_once("modules/SimpleCarto/lib/g_params.php");
				$lamap = '<!--<script type="text/javascript" src="http://maps.google.com/maps?file=api&v=2&key='.$keymap.'" charset="UTF-8"></script>-->
						<script type="text/javascript" src="https://maps.googleapis.com/maps/api/js?v=3&key='.$keymap.'" charset="UTF-8"></script>
					    <script type="text/javascript" src="modules/SimpleCarto/lib/'.$scriptcarto.'"  charset="UTF-8"></script>
						<script type="text/javascript">
						//<![CDATA[
						var options = new Array;';
				$btns = "";
				foreach ($cartobuttons as $typedemap) {
					$btns .= ($btns == "") ? "" : ",";
					$btns .= "'".$typedemap."'";
				}
				$lamap .= '
				options["btnstypes"] = ['.$btns.'];';
				$lamap .= 'options["anchor_picto"] = "'.$cartopospicto.'";';
				$lamap .= 'options["width_picto"] = '.$cartopictowidth.';';
				$lamap .= 'options["height_picto"] = '.$cartopictoheight.';';
				
				if($cartopleinecran == "1") {
					$lamap .= 'options["fullscreen"] = true;';
				} 
				else {
					$lamap .= 'options["fullscreen"] = false;';
				}
				
				$lamap .= '
				var racine_lib_module = "modules/SimpleCarto/lib";
			    //]]>
			    </script>
			    <script type="text/javascript">
				// <![CDATA[
					addToStart("GetMap(\''.$idmap.'\', \''.$tailleforcee.'\')");
					//addToStop(GUnload);
				// ]]>
				</script>
			    	'.$style.'
				<div id="map"'.$styleMap.'></div>';
			}
			$nbre = 1;
			$letexte = str_replace($tabcarte, $lamap, $letexte,$nbre);
		}
	}
	return $letexte;
}

function insert_photo_zoom($letexte, $ismobile = false) {
	global $Default_Theme;
	//le preg_match_all ne sert  rien pour l'instant : une seule carte peut tre affiche  la fois... 
	if (preg_match_all("/<img[^>]+type=\"photozoom(crop)?\"[^>]*>/im", $letexte, $tabcartes, PREG_PATTERN_ORDER)) {
		foreach ($tabcartes[0] as $tabphotos) {
			$heightphoto = "";
			if (preg_match("/<img([^>]*)height=\"([^\"]*)\"([^>]*)>/i", $tabphotos, $tabval) != 0) {
				$heightphoto = $tabval[2];
			}
			if (preg_match("/<img([^>]*)height: ([0-9]+)([^>]*)>/i", $tabphotos, $tabval) != 0) {
				$heightphoto = $tabval[2];
			}
			$widthphoto = "";
			if (preg_match("/<img([^>]*)width=\"([^\"]*)\"([^>]*)>/i", $tabphotos, $tabval) != 0) {
				$widthphoto = $tabval[2];
			}
			if (preg_match("/<img([^>]*)width: ([0-9]+)([^>]*)>/i", $tabphotos, $tabval) != 0) {
				$widthphoto = $tabval[2];
			}
			$srcphoto = "";
			if (preg_match("/<img([^>]*)src=\"([^\"]*)\"([^>]*)>/i", $tabphotos, $tabval) != 0) {
				$srcphoto = $tabval[2];
			}
			$titlephotos = "";
			if (preg_match("/<img([^>]*)title=\"([^\"]*)\"([^>]*)>/i", $tabphotos, $tabval) != 0) {
				$titlephotos = $tabval[2];
			}
			$typezoom = "";
			if (preg_match("/<img([^>]*)type=\"([^\"]*)\"([^>]*)>/i", $tabphotos, $tabval) != 0) {
				$typezoom = $tabval[2];
			}
			
			$sortie = "";
			
			if (file_exists("themes/".$Default_Theme."/pattern_zoom_photo.php")) {
				require("themes/".$Default_Theme."/pattern_zoom_photo.php");
				$laphoto = $sortie;
			}
			else {
				/*if ($ismobile) {
					$laphoto = $tabphotos;
				}
				else {*/
					if ($typezoom == "photozoom") {
						$laphoto = '<a class="photoz" href="'.$srcphoto.'" data-fancybox-group="photosz" title="'.$titlephotos.'"><img src="'.$srcphoto.'" alt="" width="'.$widthphoto.'" height="'.$heightphoto.'" /></a>';
					}
					if ($typezoom == "photozoomcrop") {
						$laphoto = '<a class="photoz" href="'.$srcphoto.'" data-fancybox-group="photosz" title="'.$titlephotos.'"><img src="modules.php?name=becmsGallery&sop=Cropper&imgfile='.$srcphoto.'&max_width='.$widthphoto.'&max_height='.$heightphoto.'" alt="" width="'.$widthphoto.'" height="'.$heightphoto.'" /></a>';
					}
				//}
			}
					
			$nbre = 1;
			$letexte = str_replace($tabphotos, $laphoto, $letexte, $nbre);
		}
	}
	return $letexte;
}

/**
 * message_box()
 * Display message in Home page (before module content)
 * Messages are always displayed if there are one
 */
function message_box() {
	global $bgcolor1, $bgcolor2, $user, $admin, $cookie, $textcolor2, $prefix, $multilingual, $currentlang, $db;
	if ($multilingual == 1) {
		$querylang = "AND (mlanguage='$currentlang' OR mlanguage='')";
	} 
	else {
		$querylang = "";
	}
	$result = $db->sql_query("select mid, title, content, date, expire, view from ".$prefix."_message where active='1' $querylang");
	if ($db->sql_numrows($result) == 0) {
  		return;
	} 
	else {
  		while (list($mid, $title, $content, $mdate, $expire, $view) = $db->sql_fetchrow($result)) {
		  	if ($title != "" && $content != "") {
		  		if ($expire == 0) {
		  			$remain = _UNLIMITED;
		  		}
		  		else {
		  			$etime = (($mdate+$expire)-time())/3600;
		  			$etime = (int)$etime;
		  			if ($etime < 1) {
		  				$remain = _EXPIRELESSHOUR;
		  			}
		  			else {
		  				$remain = ""._EXPIREIN." $etime "._HOURS."";
		  			}
		  		}
		  		// if message title stat by !!! the title will not be displayed
		  		// Notez l'utilisation de ===.  Un simple == ne donnerait pas le rsultat escompt
		  		// car la lettre 'a' est  la position 0 (la premire).
		  		if (strpos($title,"!!!") === false){
		  			$thetitle="<h1>$title</h1>\n";
		  		}
		  		else {
		  			$thetitle="";
		  		}
		  		
		  		global $section_data;
				$content = addslashes($content);
				$content = "\$content=\"".$content."\";";
				eval($content);
				$content = stripslashes($content);
				
		  		$content = insert_video_player($content);
		  		$content = insert_simple_map($content);
		  		
		  		if ($view == 4 AND is_admin($admin)) {
				    	echo $thetitle;
				    	echo $content;
				    	adminEditButton("system.php?op=editmsg&mid=$mid",_MVIEWADMIN." - $remain -");
  				} 
  				elseif ($view == 3 AND !is_user($user)) {
  					echo $thetitle;
		  			echo $content;
		  			adminEditButton("system.php?op=editmsg&mid=$mid",_MVIEWUSERS." - $remain -");
  				}
  				elseif ($view == 2 AND is_user($user)) {
			    	echo $thetitle;
			    	echo $content;
			    	adminEditButton("system.php?op=editmsg&mid=$mid",_MVIEWANON." - $remain -");
  				}
  				elseif ($view == 1) {
			    	echo $thetitle;
			    	echo $content;
			    	adminEditButton("system.php?op=editmsg&mid=$mid",_MVIEWALL." - $remain -");
  				}
  				if ($expire != 0) {
		  			$past = time()-$expire;
		  			if ($mdate < $past) {
  						$result = $db->sql_query("update ".$prefix."_message set active='0' where mid='$mid'");
					}
				}
			}
		}
	}
	$db->sql_freeresult($result);
}


function online() {
	global $user,$admin,$aid, $cookie, $prefix, $db;

	cookiedecode($user);
	$ip = getenv("REMOTE_ADDR");
	$username = $cookie[1];

	if (is_admin($admin)){
		if (isset($aid)) $username=$aid;
		$guest = 0;
	}elseif (!isset($username)) {
		$username = "$ip";
		$guest = 1;
	}

	$past = time()-600;
	$db->sql_query("DELETE FROM ".$prefix."_session WHERE time < $past");
	$result = $db->sql_query("SELECT time FROM ".$prefix."_session WHERE username='$username'");
	$ctime = time();
	if ($row = $db->sql_fetchrow($result)) {
		$db->sql_query("UPDATE ".$prefix."_session SET username='$username', time='$ctime', host_addr='$ip', guest='$guest' WHERE username='$username'");
	} else {
		$db->sql_query("INSERT INTO ".$prefix."_session (username, time, host_addr, guest) VALUES ('$username', '$ctime', '$ip', '$guest')");
	}
	$db->sql_freeresult($result);
}

function blockfileinc($title, $blockfile, $side=0) {
	$blockfiletitle = $title;
	$file = @file("blocks/$blockfile");
	if (!$file) {
		$content = _BLOCKPROBLEM;
	} else {
		include("blocks/$blockfile");
	}
	if ($content == "") {
		$content = _BLOCKPROBLEM2;
	}
	if ($content != _BLOCKPROBLEM2) {
		if ($side == 1) {
			themecenterbox($blockfiletitle, $content);
		} else {
			themesidebox($blockfiletitle, $content);
		}
	}
}

function selectlanguage() {
	global $useflags, $currentlang;
	if ($useflags == 1) {
		$title = _SELECTLANGUAGE;
		$content = "<center><font class=\"content\">"._SELECTGUILANG."<br><br>";
		$langdir = dir("language");
		while($func=$langdir->read()) {
			if(substr($func, 0, 5) == "lang-") {
				$menulist .= "$func ";
			}
		}
		closedir($langdir->handle);
		$menulist = explode(" ", $menulist);
		sort($menulist);
		for ($i=0; $i < sizeof($menulist); $i++) {
			if($menulist[$i]!="") {
				$tl = preg_replace("#lang-#","",$menulist[$i]);
				$tl = preg_replace("#.php#","",$tl);
				$altlang = ucfirst($tl);
				$content .= "<a href=\"index.php?newlang=$tl\"><img src=\"images/language/flag-$tl.png\" border=\"0\" alt=\"$altlang\" hspace=\"3\" vspace=\"3\"></a> ";
			}
		}
		$content .= "</font></center>";
		themesidebox($title, $content);
	} else {
		$title = _SELECTLANGUAGE;
		$content = "<center><font class=\"content\">"._SELECTGUILANG."<br><br></font>";
		$content .= "<form action=\"index.php\" method=\"get\"><select name=\"newlanguage\" onChange=\"top.location.href=this.options[this.selectedIndex].value\">";
		$handle=opendir('language');
		while ($file = readdir($handle)) {
			if (preg_match("/^lang\-(.+)\.php/", $file, $matches)) {
				$langFound = $matches[1];
				$languageslist .= "$langFound ";
			}
		}
		closedir($handle);
		$languageslist = explode(" ", $languageslist);
		sort($languageslist);
		for ($i=0; $i < sizeof($languageslist); $i++) {
			if($languageslist[$i]!="") {
				$content .= "<option value=\"index.php?newlang=$languageslist[$i]\" ";
				if($languageslist[$i]==$currentlang) $content .= " selected";
				$content .= ">".ucfirst($languageslist[$i])."</option>\n";
			}
		}
		$content .= "</select></form></center>";
		themesidebox($title, $content);
	}
}

function ultramode() {
	global $prefix, $db;
	$ultra = "ultramode.txt";
	$file = fopen("$ultra", "w");
	fwrite($file, "General purpose self-explanatory file with news headlines\n");
	$rfile=$db->sql_query("select sid, aid, title, time, comments, topic from ".$prefix."_stories order by time DESC limit 0,10");
	while(list($sid, $aid, $title, $time, $comments, $topic) = $db->sql_fetchrow($rfile)) {
		$rfile2=$db->sql_query("select topictext, topicimage from ".$prefix."_topics where topicid=$topic");
		list($topictext, $topicimage) = $db->sql_fetchrow($rfile2);
		$db->sql_freeresult($rfile2);
		$content = "%%\n$title\n/modules.php?name=News&file=article&sid=$sid\n$time\n$aid\n$topictext\n$comments\n$topicimage\n";
		fwrite($file, $content);
	}
	$db->sql_freeresult($rfile);
	fclose($file);
}

function cookiedecode($user) {
	global $cookie, $prefix, $db, $user_prefix;
	$user = base64_decode($user);
	$cookie = explode(":", $user);
	$result = $db->sql_query("select pass from ".$user_prefix."_users where uname='$cookie[1]'");
	list($pass) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	if ($cookie[2] == $pass && $pass != "") {
		return $cookie;
	}
	else {
		unset($user);
		unset($cookie);
	}
}

/**
 * getusrinfo
 * @param string
 * @return array user informations
 */
function getusrinfo($user) {
	global $userinfo, $user_prefix, $db;
	if (!is_array($user)){
		$user2 = base64_decode($user);
	} else {
		$user2=$user;
	}
	$user3 = explode(":", $user2);
	//$result = $db->sql_query("select uid, name, uname, email, femail, url, user_avatar, user_icq, user_occ, user_from, user_interests, user_sig, user_viewemail, user_theme, user_aim, user_yim, user_msnm, pass, storynum, umode, uorder, thold, noscore, bio, ublockon, ublock, theme, commentmax, newsletter from ".$user_prefix."_users where uname='$user3[1]' and pass='$user3[2]'");
	$result = $db->sql_query("select * from ".$user_prefix."_users where uname='$user3[1]' and pass='$user3[2]'");
	if ($db->sql_numrows($result) == 1) {
		$userinfo = $db->sql_fetchrow($result);
	}
	$db->sql_freeresult($result);
	return $userinfo;
}

function searchblock() {
	OpenTable();
	echo "<form action=\"modules.php?name=Forum&file=search\" method=\"post\">";
	echo "<input type=\"hidden\" name=\"addterm\" value=\"any\">";
	echo "<input type=\"hidden\" name=\"sortby\" value=\"p.post_time\">";
	echo "&nbsp;&nbsp;<b>"._SEARCH."</b>&nbsp;<input type=\"text\" name=\"term\" size=\"15\">";
	echo "<input type=\"hidden\" name=\"submit\" value=\"submit\"></form>";
	echo "<div align=\"left\"><font class=\"content\">&nbsp;&nbsp;[ <a href=\"modules.php?name=Forum&file=search&addterm=any&amp;sortby=p.post_time&amp;adv=1\">Advanced Search</a> ]</font></div>";
	CloseTable();
}

function FixQuotes ($what = "") {
	$what = preg_replace("#'#","''",$what);
	while (preg_match("#\\\\'#i", $what)) {
		$what = preg_replace("#\\\\'#","'",$what);
	}
	return $what;
}
function FixQuotesFile ($what = "") {
	while (preg_match("#\\\\'#i", $what)) {
		$what = preg_replace("#\\\\'#","'",$what);
	}
	return $what;
}
/**
 * fixJSQuotes
 * solve cote issue when a string is provided as javascript function parameter.
 * @param string text to clean
 * @return js clean code
 */
function fixJSQuotes($what = "") {
	$what = str_replace("'", "\'", $what);
	$what = str_replace('"', "&quot;", $what);
	return $what;
}

/*********************************************************/
/* text filter                                           */
/*********************************************************/

function check_words($Message) {
	global $EditedMessage;
	include("config.php");
	$EditedMessage = $Message;
	if ($CensorMode != 0) {

		if (is_array($CensorList)) {
			$Replace = $CensorReplace;
			if ($CensorMode == 1) {
				for ($i = 0; $i < count($CensorList); $i++) {
					$EditedMessage = preg_replace("#$CensorList[$i]([^a-zA-Z0-9])#i","$Replace\\1",$EditedMessage);
				}
			} elseif ($CensorMode == 2) {
				for ($i = 0; $i < count($CensorList); $i++) {
					$EditedMessage = preg_replace("#(^|[^[:alnum:]])$CensorList[$i]#i","\\1$Replace",$EditedMessage);
				}
			} elseif ($CensorMode == 3) {
				for ($i = 0; $i < count($CensorList); $i++) {
					$EditedMessage = preg_replace("#$CensorList[$i]#i","$Replace",$EditedMessage);
				}
			}
		}
	}
	return ($EditedMessage);
}

function delQuotes($string){
	/* no recursive function to add quote to an HTML tag if needed */
	/* and delete duplicate spaces between attribs. */
	$tmp="";    # string buffer
	$result=""; # result string
	$i=0;
	$attrib=-1; # Are us in an HTML attrib ?   -1: no attrib   0: name of the attrib   1: value of the atrib
	$quote=0;   # Is a string quote delimited opened ? 0=no, 1=yes
	$len = strlen($string);
	while ($i<$len) {
		switch($string[$i]) { # What car is it in the buffer ?
			case "\"": #"       # a quote.
				if ($quote==0) {
					$quote=1;
				} else {
					$quote=0;
					if (($attrib>0) && ($tmp != "")) { $result .= "=\"$tmp\""; }
					$tmp="";
					$attrib=-1;
				}
				break;
			case "=":           # an equal - attrib delimiter
				if ($quote==0) {  # Is it found in a string ?
					$attrib=1;
					if ($tmp!="") $result.=" $tmp";
					$tmp="";
				} else $tmp .= '=';
				break;
			case " ":           # a blank ?
				if ($attrib>0) {  # add it to the string, if one opened.
					$tmp .= $string[$i];
				}
				break;
			default:            # Other
				if ($attrib<0)    # If we weren't in an attrib, set attrib to 0
				$attrib=0;
				$tmp .= $string[$i];
				break;
		}
		$i++;
	}
	if (($quote!=0) && ($tmp != "")) {
		if ($attrib==1) $result .= "=";
		/* If it is the value of an atrib, add the '=' */
		$result .= "\"$tmp\"";  /* Add quote if needed (the reason of the function ;-) */
	}
	return $result;
}

function check_html ($str, $strip="") {
	/* The core of this code has been lifted from phpslash */
	/* which is licenced under the GPL. */
	include("config.php");
	if ($strip == "nohtml") $AllowableHTML=array('');
	$str = stripslashes($str);
	$str = preg_replace("#<[[:space:]]*([^>]*)[[:space:]]*>#i",'<\\1>', $str);
	// Delete all spaces from html tags .
	$str = preg_replace("#<a[^>]*href[[:space:]]*=[[:space:]]*\"?[[:space:]]*([^\" >]*)[[:space:]]*\"?[^>]*>#i", '<a href="\\1">', $str); # "
	// Delete all attribs from Anchor, except an href, double quoted.
	$str = preg_replace("#<img?#i",'', $str); # "
	$tmp = "";
	while (preg_match("#<(/?[[:alpha:]]*)[[:space:]]*([^>]*)>#",$str,$reg)) {
		$i = strpos($str,$reg[0]);
		$l = strlen($reg[0]);
		if ($reg[1][0] == "/") $tag = strtolower(substr($reg[1],1));
		else $tag = strtolower($reg[1]);
		if ($a = $AllowableHTML[$tag]) {
			if ($reg[1][0] == "/") {
				$tag = "</$tag>";
			}
			elseif 	(($a == 1) || ($reg[2] == "")) {
				$tag = "<$tag>";
			}
			else {
				# Place here the double quote fix function.
				$attrb_list=delQuotes($reg[2]);
				// A VER
				$attrb_list = preg_replace("#&#","&amp;",$attrb_list);
				$tag = "<$tag" . $attrb_list . ">";
			} # Attribs in tag allowed
		}
		else {
			$tag = "";
		}
		$tmp .= substr($str,0,$i) . $tag;
		$str = substr($str,$i+$l);
	}
	$str = $tmp . $str;
	return $str;
	exit;
	/* Squash PHP tags unconditionally */
	$str = preg_replace("#<\?#","",$str);
	return $str;
}

function filter_text($Message, $strip="") {
	global $EditedMessage;
	check_words($Message);
	$EditedMessage=check_html($EditedMessage, $strip);
	return ($EditedMessage);
}

/*********************************************************/
/* formatting stories                                    */
/*********************************************************/

function formatTimestamp($time, $datestring=_DATESTRING) {
	global $datetime, $locale;
	setlocale (LC_TIME, "$locale");
	preg_match ("#([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})#", $time, $datetime);
	$datetime = strftime("".$datestring."", mktime((int)$datetime[4],(int)$datetime[5],(int)$datetime[6],(int)$datetime[2],(int)$datetime[3],(int)$datetime[1]));
	$datetime = ucfirst($datetime);
	return($datetime);
}

function formatAidHeader($aid) {
	global $prefix, $db;
	$holder = $db->sql_query("SELECT url, email FROM ".$prefix."_authors where aid='$aid'");
	if (!$holder) {
		echo _ERROR;
		exit();
	}
	list($url, $email) = $db->sql_fetchrow($holder);
	$db->sql_freeresult($holder);
	if ($url != "") {
		$aid = "<a href=\"$url\">$aid</a>";
	}
	elseif (isset($email)) {
		$aid = "<a href=\"mailto:$email\">$aid</a>";
	}
	else {
		$aid = $aid;
	}
	echo "$aid";
}

function get_author($aid) {
	global $prefix, $db;
	$holder = $db->sql_query("SELECT url, email FROM ".$prefix."_authors where aid='$aid'");
	if (!$holder) {
		echo _ERROR;
		exit();
	}
	list($url, $email) = $db->sql_fetchrow($holder);
	$db->sql_freeresult($holder);
	if (isset($url)) {
		$aid = "<a href=\"$url\">$aid</a>";
	} elseif (isset($email)) {
		$aid = "<a href=\"mailto:$email\">$aid</a>";
	} else {
		$aid = $aid;
	}
	return($aid);
}

function themepreview($title, $hometext, $bodytext="", $notes="") {
	/*echo "<b>$title</b><br><br>$hometext";
	 if ($bodytext != "") {
	 echo "<br><br>$bodytext";
	 }
	 if ($notes != "") {
	 echo "<br><br><b>"._NOTE."</b> <i>$notes</i>";
	 }*/
	echo "<h1>".$title."</h1>";
	if ($notes != "") {
		$notes = "<hr class=\"news\" /><p class=\"note\"><span class=\"title\">"._NOTE."</span> $notes</p>\n";
	}
	else {
		$notes = "";
	}
	if($bodytext == "") {
		$bodytext = "$hometext$notes";
	}
	else {
		$bodytext = "<div class=\"news_content_abstract\">$hometext</div>$bodytext$notes";
	}
	echo $bodytext;
}

function adminblock() {
	global $admin, $prefix, $db;
	if (is_admin($admin)) {
		$result = $db->sql_query("select title, content from ".$prefix."_blocks where bkey='admin'");
		while(list($title, $content) = $db->sql_fetchrow($result)) {
			$content = "<font class=\"content\">$content</font>";
			themesidebox($title, $content);
		}
		$db->sql_freeresult($result);
		$title = ""._WAITINGCONT."";
		$result = $db->sql_query("select * from ".$prefix."_queue");
		$num = $db->sql_numrows($result);
		$db->sql_freeresult($result);
		$content = "";
		$content .= "<span class=\"blocklink\">&nbsp;<a href=\"system.php?op=submissions\">"._SUBMISSIONS."</a>: $num<br></span>";
		$result = $db->sql_query("select * from ".$prefix."_reviews_add");
		$num = $db->sql_numrows($result);
		$content .= "<span class=\"blocklink\">&nbsp;<a href=\"system.php?op=reviews\">"._WREVIEWS."</a>: $num</span><br>";
		$result = $db->sql_query("select * from ".$prefix."_links_newlink");
		$num = $db->sql_numrows($result);
		$content .= "<span class=\"blocklink\">&nbsp;<a href=\"system.php?op=Links\">"._WLINKS."</a>: $num</span><br>";
		$result = $db->sql_query("select * from ".$prefix."_downloads_newdownload");
		$num = $db->sql_numrows($result);
		$content .= "<span class=\"blocklink\">&nbsp;<a href=\"system.php?op=downloads\">"._UDOWNLOADS."</a>: $num</span><br>";
		$db->sql_freeresult($result);
		themesidebox($title, $content);
	}
}
/**
 function loginbox() {
 global $user;
 if (!is_user($user)) {
	$title = _LOGIN;
	$boxstuff = "<form action=\"modules.php?name=Your_Account\" method=\"post\">";
	$boxstuff .= "<center><font class=\"content\">"._NICKNAME."<br>";
	$boxstuff .= "<input type=\"text\" name=\"uname\" size=\"8\" maxlength=\"25\"><br>";
	$boxstuff .= ""._PASSWORD."<br>";
	$boxstuff .= "<input type=\"password\" name=\"pass\" size=\"8\" maxlength=\"20\"><br>";
	$boxstuff .= "<input type=\"hidden\" name=\"op\" value=\"login\">";
	$boxstuff .= "<input type=\"submit\" value=\""._LOGIN."\"></font></center></form>";
	$boxstuff .= "<center><font class=\"content\">"._ASREGISTERED."</font></center>";
	themesidebox($title, $boxstuff);
	}
	}
	*/
function loginbox() {
	global $user, $sitekey, $gfx_chk;
	mt_srand ((double)microtime()*1000000);
	$maxran = 1000000;
	$random_num = mt_rand(0, $maxran);
	$datekey = date("F j");
	$rcode = hexdec(md5($_SERVER['HTTP_USER_AGENT'] . $sitekey . $random_num . $datekey));
	$code = substr($rcode, 2, 6);
	if (!is_user($user)) {
		$title = _LOGIN;
		$boxstuff = "<form action=\"modules.php?name=Your_Account\" method=\"post\">";
		$boxstuff .= "<center><font class=\"content\">"._NICKNAME."<br>";
		$boxstuff .= "<input type=\"text\" name=\"username\" size=\"8\" maxlength=\"25\"><br>";
		$boxstuff .= ""._PASSWORD."<br>";
		$boxstuff .= "<input type=\"password\" name=\"user_password\" size=\"8\" maxlength=\"20\"><br>";
		if (extension_loaded("gd") AND ($gfx_chk == 2 OR $gfx_chk == 4 OR $gfx_chk == 5 OR $gfx_chk == 7)) {
			$boxstuff .= ""._SECURITYCODE.": <img src='?gfx=gfx&amp;random_num=$random_num' border='1' alt='"._SECURITYCODE."' title='"._SECURITYCODE."'><br>\n";
			$boxstuff .= ""._TYPESECCODE."<br><input type=\"text\" NAME=\"gfx_check\" SIZE=\"7\" MAXLENGTH=\"6\">\n";
			$boxstuff .= "<input type=\"hidden\" name=\"random_num\" value=\"$random_num\"><br>\n";
		} else {
			$boxstuff .= "<input type=\"hidden\" name=\"random_num\" value=\"$random_num\">";
			$boxstuff .= "<input type=\"hidden\" name=\"gfx_check\" value=\"$code\">";
		}
		$boxstuff .= "<input type=\"hidden\" name=\"op\" value=\"login\">";
		$boxstuff .= "<input type=\"submit\" value=\""._LOGIN."\"></font></center></form>";
		$boxstuff .= "<center><font class=\"content\">"._ASREGISTERED."</font></center>";
		themesidebox($title, $boxstuff);
	}
}

function userblock() {
	global $user, $cookie, $prefix, $db, $user_prefix;
	if((is_user($user)) AND ($cookie[8])) {
		$getblock = $db->sql_query("select ublock from ".$user_prefix."_users where uid='$cookie[0]'");
		$title = ""._MENUFOR." $cookie[1]";
		list($ublock) = $db->sql_fetchrow($getblock);
		$db->sql_freeresult($getblock);
		themesidebox($title, $ublock);
	}
}

function getTopics($s_sid) {
	global $topicid,$topicname, $topicimage, $topictext, $prefix, $db;
	$sid = $s_sid;
	$result = $db->sql_query("SELECT topic FROM ".$prefix."_stories where sid=$sid");
	list($topic) = $db->sql_fetchrow($result);
	$result = $db->sql_query("SELECT topicid, topicname, topicimage, topictext FROM ".$prefix."_topics where topicid=$topic");
	list($topicid, $topicname, $topicimage, $topictext) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
}
/**
 * headlines($bid, $cenbox=0)
 * @param int rss server DB ID
 * @param int rss fulx position as block or as page (default)
 */
function headlines($bid, $cenbox=0) {
	global $prefix, $db;
	$result = $db->sql_query("select title, content, url, refresh, time from ".$prefix."_blocks where bid='$bid'");
	list($title, $content, $url, $refresh, $otime) = $db->sql_fetchrow($result);
	$db->sql_freeresult($result);
	$past = time()-$refresh;
	if ($otime < $past) {
		$btime = time();
		$rdf = parse_url($url);
		$fp = fsockopen($rdf['host'], 80, $errno, $errstr, 15);
		if (!$fp) {
			$content = "";
			//$content = "<font class=\"content\">"._RSSPROBLEM."</font>";
			$result = $db->sql_query("update ".$prefix."_blocks set content='$content', time='$btime' where bid='$bid'");
			$cont = 0;
			if ($cenbox == 0) {
				themesidebox($title, $content);
			} else {
				themecenterbox($title, $content);
			}
			return;
		}
		if ($fp) {
			fputs($fp, "GET " . $rdf['path'] . "?" . $rdf['query'] . " HTTP/1.0\r\n");
			fputs($fp, "HOST: " . $rdf['host'] . "\r\n\r\n");
			$string	= "";
			while(!feof($fp)) {
				$pagetext = fgets($fp,300);
				$string .= chop($pagetext);
			}
			fputs($fp,"Connection: close\r\n\r\n");
			fclose($fp);
			if (preg_match('/encoding="utf-8"/mi',$string)) {
	    			$string = str_replace("’","'",$string);
	    			$string = utf8_decode($string);
	    		}
			$items = explode("</item>",$string);
			$content = "<ul class=\"listactus\">";
			global $numberRSSitems;
			for ($i=0;$i<$numberRSSitems;$i++) {
				$link = preg_replace("#.*<link>#","",$items[$i]);
				$link = preg_replace("#</link>.*#","",$link);
			
				$title2 = preg_replace("#.*<title>#","",$items[$i]);
				$title2 = preg_replace("#</title>.*#","",$title2);
				$title2 = str_replace('<![CDATA[','',$title2);
	    			$title2 = str_replace(']]>','',$title2);
				if ($items[$i] == "") {
					$content = "";
					$db->sql_query("update ".$prefix."_blocks set content='$content', time='$btime' where bid='$bid'");
					$cont = 0;
					if ($cenbox == 0) {
						themesidebox($title, $content);
					} else {
						themecenterbox($title, $content);
					}
					return;
				}
				else {
					if (strcmp($link,$title)) {
						$cont = 1;
						$content .= "<li><a href=\"$link\" target=\"new\">$title2</a></li>\n";
					}
				}

			}
			$content .= "</ul>";
		}
		$db->sql_query("update ".$prefix."_blocks set content='$content', time='$btime' where bid='$bid'");
	}
	$siteurl = preg_replace("#http://#","",$url);
	$siteurl = explode("/",$siteurl);
	if (($cont == 1) OR ($content != "")) {
		$content .= "<div id=\"moreacts\"><a href=\"http://$siteurl[0]\" target=\"blank\"><b>"._HREADMORE."</b></a></div>";
	} elseif (($cont == 0) OR ($content == "")) {
		$content = "<font class=\"content\">"._RSSPROBLEM."</font>";
	}
	if ($cenbox == 0) {
		themesidebox($title, $content);
	} else {
		themecenterbox($title, $content);
	}
}

function automated_news() {
	global $prefix, $multilingual, $currentlang, $db;
	if ($multilingual == 1) {
		$querylang = "WHERE (alanguage='$currentlang' OR alanguage='')"; /* the OR is needed to display stories who are posted to ALL languages */
	} 
	else {
		$querylang = "";
	}
	/*$today = getdate();
	$day = $today[mday];
	if ($day < 10) {
		$day = "0$day";
	}
	$month = $today[mon];
	if ($month < 10) {
		$month = "0$month";
	}
	$year = $today[year];
	$hour = $today[hours];
	$min = $today[minutes];
	$sec = "00";*/
	$result = $db->sql_query("select anid, time from ".$prefix."_autonews $querylang");
	while(list($anid, $time) = $db->sql_fetchrow($result)) {
		//preg_match ("#([0-9]{4})-([0-9]{1,2})-([0-9]{1,2}) ([0-9]{1,2}):([0-9]{1,2}):([0-9]{1,2})#", $time, $date);
		//if (($date[1] <= $year) AND ($date[2] <= $month) AND ($date[3] <= $day)) {
		//	if (($date[4] < $hour) AND ($date[5] >= $min) OR ($date[4] <= $hour) AND ($date[5] <= $min)) {
		if (date("Y-m-d H:i:s") >= $time) {
				$result2 = $db->sql_query("select catid, aid, title, time, hometext, bodytext, topic, informant, notes, ihome, alanguage, acomm, haspoll, pollID, status from ".$prefix."_autonews where anid='$anid'");
				while(list($catid, $aid, $title, $a_time, $hometext, $bodytext, $topic, $author, $notes, $ihome, $alanguage, $acomm, $haspoll, $pollID, $status) = $db->sql_fetchrow($result2)) {
					$title = stripslashes(FixQuotes($title));
					$hometext = stripslashes(FixQuotes($hometext));
					$bodytext = stripslashes(FixQuotes($bodytext));
					$notes = stripslashes(FixQuotes($notes));
					$aid = stripslashes(FixQuotes($aid));
					$author = stripslashes(FixQuotes($author));
					$db->sql_query("insert into ".$prefix."_stories values (NULL, '$catid', '$aid', '$title', '$a_time', '$hometext', '$bodytext', '0', '0', '$topic', '$author', '$notes', '$ihome', '$alanguage', '$acomm', '$haspoll', '$pollID', '0', '0','$status')");
					$db->sql_query("delete from ".$prefix."_autonews where anid='$anid'");
				}
		}
		//	}
		//}
	}
}

function public_message() {
	global $prefix, $user_prefix, $db, $user, $admin, $p_msg, $cookie, $broadcast_msg;
	if ($broadcast_msg == 1) {
		if (is_user($user)) {
			cookiedecode($user);
			$result = $db->sql_query("SELECT broadcast FROM ".$user_prefix."_users WHERE uname='$cookie[1]'");
			$row = $db->sql_fetchrow($result);
			$upref = intval($row['broadcast']);
			if ($upref == 1) {
				$t_off = "<p align=\"right\">[<a href=\"modules.php?name=Your_Account&amp;op=edithome\">"._TURNOFFMSG."</a>]</p>";
				$pm_show = 1;
			} else {
				$pm_show = 0;
			}
		} else {
			$t_off = "";
		}
		if (!is_user($user) OR (is_user($user) AND ($pm_show == 1))) {
			$c_mid = base64_decode($p_msg);
			$c_mid = addslashes($c_mid);
			$c_mid = intval($c_mid);
			$result2 = $db->sql_query("SELECT mid, content, date, who FROM ".$prefix."_public_messages WHERE mid > '$c_mid' ORDER BY date ASC LIMIT 1");
			$row2 = $db->sql_fetchrow($result2);
			$mid = intval($row2['mid']);
			$content = filter($row2['content'], "nohtml");
			$tdate = $row2['date'];
			$who = filter($row2['who'], "nohtml");
			if ((!isset($c_mid)) OR ($c_mid = $mid)) {
				$public_msg = "<div id=\"messageBroadcast\">";
				$public_msg .= "<h1>"._BROADCASTFROM." <a href=\"modules.php?name=Your_Account&amp;op=userinfo&amp;username=$who\">$who</a></h1>";
				$public_msg .= "<p>".$content."</p>";
				$public_msg .= $t_off;
				$public_msg .= "</div>";
				$ref_date = $tdate+600;
				$actual_date = time();
				if ($actual_date >= $ref_date) {
					$public_msg = "";
					$numrows = $db->sql_numrows($db->sql_query("SELECT * FROM ".$prefix."_public_messages"));
					if ($numrows == 1) {
						$db->sql_query("DELETE FROM ".$prefix."_public_messages");
						$mid = 0;
					} else {
						$db->sql_query("DELETE FROM ".$prefix."_public_messages WHERE mid='$mid'");
					}
				}
				if ($mid == 0 OR empty($mid)) {
					setcookie("p_msg");
				} else {
					$mid = base64_encode($mid);
					$mid = addslashes($mid);
					setcookie("p_msg",$mid,time()+600);
				}
			}
		}
	} else {
		$public_msg = "";
	}
	return $public_msg;
}


function themecenterbox($title, $content) {
	OpenTable();
	echo "<center><fon class=\"option\"><b>$title</b></font></center><br>"
	."$content";
	CloseTable();
	echo "<br>";
}
/**
 * sideboxbar()
 * display or hide sidebox with one clik
 * @return
 * @see theme.html
 */
function sideboxbar($theTitle=""){
	global $Default_Skin;
	$sideboxbar="<style>.sideblockright { display: none; }\n .sideblockleft { display: none; }</style>";
	$sideboxbar.= "<SCRIPT language=\"JavaScript\" src=\"javascripts/displayIframe.js\"></SCRIPT>\n";
	$sideboxbar.="<table class=SBB_Table><tr>";
	$sideboxbar.="<td class=SBB_Left><a href=\"javascript:switchdisplayIFrame('leftblock');\"><img src=\"system/skins/$Default_Skin/button_tab_check_small_left.png\" border=0></a></td>";
	$sideboxbar.="<td class=SBB_Center>$theTitle</td>";
	$sideboxbar.="<td class=SBB_Right><a href=\"javascript:switchdisplayIFrame('rightblock');\"><img src=\"system/skins/$Default_Skin/button_tab_check_small_right.png\" border=0></a></td>";
	$sideboxbar.="</tr></table>";
	echo $sideboxbar;
}
/**
 * displayOngletBar()
 * Read language folder and generate adapted panel header with a pane for each language
 * @usage
 * $ongletDef=array("admin"=> array( "text"=>"Administration",
 *                                    "url"=>"system.php?op=block"),
 *                    "add"=> array( "text"=>"Administration",
 *                                    "url"=>"system.php?op=block"));
 * displayOngletBar("add",$ongletDef);
 * @param selected pane (onglet)
 * @param array ongletDef onglet definition. the array is an associated array with ['idname']['text']['url'] information
 * @param option suplemantal parameter for url : "topic=1". Optional
 * @return html code
 */
function displayOngletBar($selectedOnglet,$msgText,$ongletDef, $optionPara=""){
	global $Default_Skin;
	$myheader="";
	$checkx="";
	$option = "";
	if ($optionPara != "") {
		$option="&$optionPara";
	}
	$SkinPath="system/skins/$Default_Skin";

	// define text zone size
	if ((sizeof($ongletDef))>=5){
		$textsize="20%";
	} else if ((sizeof($ongletDef))>=3){
		$textsize="30%";
	} else { $textsize="50%"; }
	$tablesize=130*(sizeof($ongletDef));// add pane is included
	$myheader.="<table  width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\"><tr >\n";
	/*$myheader.= "<td align=\"left\" valign=\"bottom\" width=\"$textsize\"  height=\"30\" style=\" border-bottom: 1px solid black \"><strong><font color=\"#000000\">$msgText</font></strong></td>";
	 $myheader.= "<td valign=\"bottom\" background=\"$SkinPath/fondDarkGrayOngletBig.gif\" height=\"30\">&nbsp;</td>";*/
	$myheader.= "<td align=\"left\" valign=\"bottom\"  height=\"30\" style=\" border-bottom: 1px solid #999999\" nowrap=\"nowrap\"><strong><font color=\"#000000\">$msgText</font></strong></td>";
	foreach ($ongletDef as $key => $theOnglet) {
		if ($key==$selectedOnglet) { $checkx="Check"; } else {$checkx="";}
		$myheader.="<td width=\"130\" height=\"30\" background=\"$SkinPath/ongletGrisGrandVide$checkx.gif\"><div align=\"center\"><a href=\"".$theOnglet["url"]."$option\">".$theOnglet["text"]."</a></div></td>\n";
	}// end foreach

	$myheader .="</tr></table>\n";
	echo $myheader;
}
/**
 * captureUpload()
 * @abstract
 * Will look inside $_FILES['upload'] for an uploaded file.
 * The second parameter is the name of a callback function (false, if you don't want it), to rename the file, it will send two parameters:
 *      $file (array of file info) , $destinationDirectory
 * It should return the name of the file. This is useful if you want to do a database lookup (for CMS integration, to see who uploaded it, etc), or do some other fancy checking.
 * The function will also rename file "whatever_copy_1.gif" if "whatever.gif" already exists.
 *
 * @usage : list($success,$response) = captureUpload('./user_images/',false,'_upload');
 *
 * @param $destDir Destination directory
 * @param $nameCallback callback function (false, if you don't want it)
 * @param $fieldName new file name after upload
 * @param $maxFileSize max file size
 * @return array with upload status true or false as first entry and file name or error message as second entry
 * @see php online documentation about upload
 */
function captureUpload($destDir,$nameCallback = false,$fieldName = '_upload',$maxFileSize = false, $maxImageSize=""){

	

	//make sure something is there
	if(!isset($_FILES[$fieldName]) ||!isset($_FILES)||!is_array($_FILES[$fieldName]) ||!$_FILES[$fieldName]['name'])
	return array(false,'No files were uploaded. Make sure your form tag\'s enctype was set to multipart/form-data and that the right field is being checked for the uploaded file.');

	//normalize the file variable
	$file = $_FILES[$fieldName];
	if (!isset($file['type']))      $file['type']      = '';
	if (!isset($file['size']))      $file['size']      = '';
	if (!isset($file['tmp_name']))  $file['tmp_name']  = '';
	
	if (preg_match("#\.php([0-9]*)$#i",$file['name']) || preg_match("#\.js$#i",$file['name']) || preg_match("#\.pl$#i",$file['name']) || preg_match("#\.(x?)htm(.*)$#i",$file['name'])) {
		return array(false,'Ce type de fichiers est interdit !');
		die("Petit coquin !");
	}
	
	$file['name'] = preg_replace(
	'/[^a-zA-Z0-9\.\$\%\'\`\-\@\{\}\~\!\#\(\)\&\_\^]/'
             ,'',str_replace(array(' ','%20'),array('_','_'),$file['name']));

	//was it to big?
	if($maxFileSize && ($file['size'] > $maxFileSize))
	return array(false,'The file uploaded was to large.');

	//normalize destDir
	if(strlen($destDir)>0 && $destDir[strlen($destDir)-1] != "/")
	$destDir = $destDir.'/';

	//should we change the filename via a callback?
	if($nameCallback)
	$file['name'] = call_user_func_array($nameCallback, array($file,$destDir));

	$i = 0;
	//if the filename already exists, append _copy_x (with extension)
	if(strpos($file['name'],'.') !== false){
		$bits = explode('.',$file['name']);
		$ext = array_pop($bits);
		while(file_exists($destDir.implode('.', $bits).($i?'_copy_'.$i:'').'.'.$ext)){
			++$i;
			$file['name'] = implode('.',$bits).($i?'_copy_'.$i:'').'.'.$ext;
		}

		//if the filename already exists, append _copy_x (no extension)
	} else {
		while(file_exists($destDir.$file['name'].($i ?'_copy_'.$i:''))){
			++$i;
			$file['name'] = $file['name'].($i?'_copy_'.$i:'');
		}
	}
	//and now the big moment
	if(!@copy($file['tmp_name'], $destDir.$file['name'])) {
		return array(false,'Could not write the file "'.$file['name'].'" to: "'.$destDir.'". Permission denied.');
	}
	else {
		//redim en fonction des prefs
		if (preg_match('/(\.gif$|\.png$|\.jpg|\.jpeg)$/is', $file['name'])) {
			$filename = $destDir.$file['name'];
			$size = getimagesize($filename);
			$width = $size[0];
			$height = $size[1];
			$sExtension = substr( $filename, ( strrpos($filename, '.') + 1 ) ) ;
			$sExtension = strtolower( $sExtension ) ;
			if ($maxImageSize != "") {
				list($MaxWidth,$MaxHeight) = explode("/", $maxImageSize);
			}
			if (($width > $MaxWidth || $height > $MaxHeight ) && $maxImageSize != "") {
				//$tlist[] .= $filename." (".$width.", ".$height.", ".$sExtension.")";
				//echo $filename." (".$width.", ".$height.", ".$sExtension.")\n";
				if ($width > $height) {
					$newwidth = $MaxWidth;
					$newheight = ($height * $MaxWidth) / $width;
				}
				else {
					$newwidth = ($width * $MaxHeight) / $height;
					$newheight = $MaxHeight;
				}
				//pour les cas des jpg
				if($sExtension == 'jpg' || $sExtension == 'jpeg') {
					$src = imagecreatefromjpeg($filename);
					$tmp=imagecreatetruecolor($newwidth,$newheight);
					imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
					imagejpeg($tmp,$filename,70);
					imagedestroy($src);
					imagedestroy($tmp);
				}
				//pour les cas des gif
				if($sExtension == 'gif') {
					$src = imagecreatefromgif($filename);
					$tmp=imagecreatetruecolor($newwidth,$newheight);
					$trans = imagecolorallocate($tmp,255,255,255);
					imagefilledrectangle($tmp,0,0,$newwidth,$newheight,$trans);
					imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
					imageinterlace($tmp);
					imagegif($tmp,$filename);
					imagedestroy($src);
					imagedestroy($tmp);
				}
				//pour les cas des png
				if($sExtension == 'png') {
					$src = imagecreatefrompng($filename);
					$tmp=imagecreatetruecolor($newwidth,$newheight);
					imagealphablending($tmp, false);
					imagesavealpha($tmp, true);
					imagecopyresampled($tmp,$src,0,0,0,0,$newwidth,$newheight,$width,$height);
					$fond_noir = imagecolorallocate($destination, 0, 0, 0);
					imagecolortransparent($destination, $fond_noir);
					imagepng($tmp,$filename);
					imagedestroy($src);
					imagedestroy($tmp);
				}
			}
		}
		return array(true,$file['name']);
	}
}
/**
 *  do_thumb()
 *  Generate ThumbNails from image files .jpg, .png or .gif
 *  @param name image file name
 *  @param th_name thumbNails name
 *  @param th_height thumbNails height
 *  @return OK if opreation was done correctly, if not return error message
 *  @author Yann Courtaux (pixman@pixfr.com) for ppm projet
 */
function do_thumb($name,$th_name,$th_height) {
	global $ppmGd;
	$im = '';
	$data = @GetImageSize($name,$info);
	if($data==NULL) {
		$result = _MODpREADERROR;
	} elseif(!extension_loaded('gd')) {
		$result = _MODpGDNOTPRESENT;
	} else {
		switch ($data[2])  // open permission needed
		{   case 1: $imgtype = 'GIF';
		$im = @imagecreatefromgif($name); break; // GIF
		case 2: $imgtype = 'JPEG';
		$im = @imagecreatefromjpeg($name); break; // JPG
		case 3: $imgtype = 'PNG';
		$im = @imagecreatefrompng($name); break;  // PNG
		}
		if ($im == '')
		{   $result = $imgtype.' '._MODpFORMATNOTSUPPORTED; }
		else
		{   $w=ImageSX($im);
		$h=ImageSY($im);
		$nw=round($w * $th_height / $h);
		$nh=$th_height;
		if ($ppmGd['version2']) {       // GD 2.0 or up
			$ni = ImageCreateTrueColor($nw,$nh);
			ImageCopyResampled($ni,$im,0,0,0,0,$nw,$nh,$w,$h);
		}
		else {                           // GD version < 2
			$ni=ImageCreate($nw,$nh);
			ImageCopyResized($ni,$im,0,0,0,0,$nw,$nh,$w,$h);
		}
		ImageDestroy($im);
		switch ($imgtype)    // // write permission needed
		{   case  'GIF': imagegif($ni,$th_name);                       break;
		case 'JPEG': imagejpeg($ni,$th_name,$ppmGd['jpegcomp']); break;
		case  'PNG': imagepng($ni,$th_name);                       break;
		}
		ImageDestroy($ni);
		$result = 'OK';
		}
	}
	return $result;
}

/**
 * makeXMLTree($file)
 *@tutorial
 * put elements, that need to be put in a list here
 * $XML_LIST_ELEMENTS = array( "concert", "song" );
 * echo "<pre>";
 *  $res = makeXMLTree($xml_file, "F");
 *  var_dump($res);
 *  echo "</pre>";
 *
 *@param file xml file
 *@param type value are 'F' or 'S'. F if data are file, S if data are a string. Default value is F.
 *
 *
 *need for XML for PHP < V5.0
 * with PHP 5 it's better to use SimpleXML Api'
 */
function makeXMLTree($file, $datatype) {

	if ($datatype=="F"){
		// read file
		$open_file = fopen($file, "r");
		$data = "";
		while ($r=fread($open_file,8192) ) {
			$data .= $r;
		}
	} else {
		$data=$file ;
	}

	// create parser
	$parser = xml_parser_create();
	xml_parser_set_option($parser,XML_OPTION_CASE_FOLDING,0);
	xml_parser_set_option($parser,XML_OPTION_SKIP_WHITE,1);
	xml_parse_into_struct($parser,$data,$values,$tags);
	xml_parser_free($parser);

	// we store our path here
	$hash_stack = array();

	// this is our target
	$ret = array();
	foreach ($values as $key => $val) {

		switch ($val['type']) {
			case 'open':
				array_push($hash_stack, $val['tag']);
				if (isset($val['attributes']))
				$ret = composeArray($ret, $hash_stack, $val['attributes']);
				else
				$ret = composeArray($ret, $hash_stack);
				break;

			case 'close':
				array_pop($hash_stack);
				break;

			case 'complete':
				array_push($hash_stack, $val['tag']);
				$ret = composeArray($ret, $hash_stack, $val['value']);
				array_pop($hash_stack);

				// handle attributes
				if (isset($val['attributes']))
				{
					while(list($a_k,$a_v) = each($val['attributes']))
					{
						$hash_stack[] = $val['tag']."_attribute_".$a_k;
						$ret = composeArray($ret, $hash_stack, $a_v);
						array_pop($hash_stack);
					}
				}
				break;
		}
	}

	return $ret;
}
/**
 * composeArray()
 *
 * associated with makeXMLTree need for XML for PHP < V5.0
 * with PHP 5 it's better to use SimpleXML Api'
 */
function &composeArray($array, $elements, $value=array()) {
	global $XML_LIST_ELEMENTS;
	$XML_LIST_ELEMENTS=array("Layer");
	// get current element
	$element = array_shift($elements);

	// does the current element refer to a list
	if (in_array($element,$XML_LIST_ELEMENTS))
	{
		// more elements?
		if(sizeof($elements) > 0)
		{
			$array[$element][sizeof($array[$element])-1] = &composeArray($array[$element][sizeof($array[$element])-1], $elements, $value);
		}
		else // if (is_array($value))
		{
			$array[$element][sizeof($array[$element])] = $value;
		}
	}
	else
	{
		// more elements?
		if(sizeof($elements) > 0)
		{
			$array[$element] = &composeArray($array[$element], $elements, $value);
		}
		else
		{
			$array[$element] = $value;
		}
	}
	return $array;
}
/**
 * translateDay()
 * translate us day to forien language
 * @param language fr, es, ...
 * @param day
 * @return translated day
 */
function translateDay($lang,$day){
	// fr
	$jour["fr"]["Monday"] = "Lundi";
	$jour["fr"]["Tuesday"] = "Mardi";
	$jour["fr"]["Wednesday"] = "Mercredi";
	$jour["fr"]["Thursday"] = "Jeudi";
	$jour["fr"]["Friday"] = "Vendredi";
	$jour["fr"]["Saturday"] = "Samedi";
	$jour["fr"]["Sunday"] = "Dimanche";
	return $jour[$lang][$day];
}
/**
 * translateMonth()
 * translate us month to forien language
 * @param language fr, es, ...
 * @param month
 * @return translated month
 */
function translateMonth($lang,$month){
	// fr
	$mois["fr"]["January"] = "Janvier";
	$mois["fr"]["Jan"] = "Janvier";
	$mois["fr"]["February"] = "Fvrier";
	$mois["fr"]["Feb"] = "Fvrier";
	$mois["fr"]["March"] = "Mars";
	$mois["fr"]["Mar"] = "Mars";
	$mois["fr"]["April"] = "Avril";
	$mois["fr"]["Apr"] = "Avril";
	$mois["fr"]["May"] = "Mai";
	$mois["fr"]["June"] = "Juin";
	$mois["fr"]["Jun"] = "Juin";
	$mois["fr"]["July"] = "Juillet";
	$mois["fr"]["Jul"] = "Juillet";
	$mois["fr"]["August"] = "Aot";
	$mois["fr"]["Aug"] = "Aot";
	$mois["fr"]["September"] = "Septembre";
	$mois["fr"]["Sep"] = "Septembre";
	$mois["fr"]["October"] = "Octobre";
	$mois["fr"]["Oct"] = "Octobre";
	$mois["fr"]["November"] = "Novembre";
	$mois["fr"]["Nov"] = "Novembre";
	$mois["fr"]["December"] = "Dcembre";
	$mois["fr"]["Dec"] = "Dcembre";
	return $mois[$lang][$month];
}
/*
 * parseCSS()
 * Fonction d'analyse d'un CSS, avec retour sous forme de tableau pratique.
 * A utiliser pour exploiter des CSS dans un fichier PHP.
 *
 * $aCSS=parseCSS("style.css","f");
 *  echo $aCSS["body"]["background-color"];
 * or
 * $stringCss="#body {background-color: blue;}"
 * ...
 * $aCSS=parseCSS($stringCss,"s");
 * echo $aCSS["body"]["background-color"];
 * @param String file name
 * @param String Type s: String f: file
 * @return Array CSS file or string as an Array
 */
function parseCSS($filename,$type="f"){

 if ($type=="f"){
  $fp=fopen($filename, "r");
  $css = fread($fp, filesize ($filename));
  fclose($fp);
 } else {
  $css=$filename;
 }
 $css=preg_replace("/[\s, ]+/", "", $css);
 $css_class = preg_split("/}/", $css);

 while (list($key, $val) = each ($css_class))
 {
  $aCSSObj=preg_split("/{/", $val);
  $a=preg_split("/;/", $aCSSObj[1]);
  while(list($key, $val0) = each ($a))
  {
  	if($val0 !='')
  	{
  		$aCSSSub=preg_split("/:/", $val0);
  		$aCSSItem[$aCSSSub[0]]=$aCSSSub[1];
  	}
  }
  $aCSS[$aCSSObj[0]]=$aCSSItem;
  unset($aCSSItem);
 }
 unset($css);
 unset($css_class);
 unset($aCSSSub);
 unset($aCSSItem);
 unset($aCSSObj);
 return $aCSS;
}
/**
 * getFiles()
 * function for finding all files in a specified directory and all subdirectories.
 * It can be quite usefull when searching in alot of files in alot subdirectories.
 * The function returns an array with the path of all the files found.
 * Example of use
 * print_r(getFiles('.')); // This will find all files in the current directory and all subdirectories
 * @param directory
 * @return  an array with the path of all the files found
 */
function getFiles($directory) {
	// Try to open the directory
	if($dir = opendir($directory)) {
		// Create an array for all files found
		$tmp = Array();

		// Add the files
		while($file = readdir($dir)) {
			// Make sure the file exists
			if($file != "." && $file != ".." && $file[0] != '.') {
				// If it's a directiry, list all files within it
				if(is_dir($directory . "/" . $file)) {
					$tmp2 = getFiles($directory . "/" . $file);
					if(is_array($tmp2)) {
						$tmp = array_merge($tmp, $tmp2);
					}
				} else {
					array_push($tmp, $directory . "/" . $file);
				}
			}
		}

		// Finish off the function
		closedir($dir);
		return $tmp;
	}
}
/**
 * getMemUsage()
 * get memory usage even your are on windows box
 *
 *
 */
function getMemUsage()
{

	if (function_exists('memory_get_usage'))
	{
		return memory_get_usage()/1024;
	}
	else if ( strpos( strtolower($_SERVER["OS"]), 'windows') !== false)
	{
		// Windows workaround
		$output = array();

		exec('tasklist /FI "PID eq ' . getmypid() . '" /FO LIST', $output);
		return substr($output[5], strpos($output[5], ':') + 1);
	}
	else
	{
		return 'no value';
	}
}
/**
 * getTextImage()
 * Find an image by is name first in current theme, if image is not found find it in defaut module image folder (images/<modulename>/)
 * is no image is found display Text. Veri usefull for using img in translation file.
 * @param imageName like img.gif or img.jpg
 * @param text if image is not found.
 * @return string correct img html tag (<img src=..) if image is found else return text provided as parameter.
 */
function getTextImage($myimg, $mytext, $tagOn=true){
	global $Default_Theme,$name;
	//$mythemeimgpath="themes/$Default_Theme/images/$myimg";
	$mythemeimgpath="themes/".get_theme()."/images/$myimg";
	$mydefaultimgpath="modules/$name/images/$myimg";
	if (!empty($myimg) && (file_exists($mythemeimgpath))) {
		if ($tagOn) return "<img src=\"$mythemeimgpath\" border=0 alt=\"$mytext\" title=\"$mytext\" >";
		else return $mythemeimgpath;
	}
	else {
		if (!empty($myimg) && (file_exists($mydefaultimgpath))) {
			if ($tagOn) return "<img src=\"$mydefaultimgpath\" border=0 alt=\"$mytext\" title=\"$mytext\" >";
			else return $mydefaultimgpath;
		}
		else {
			return $mytext;
		}
	}
}
/**
 * urlActionRule()
 * return a value link to url content. return value is defined by rules.
 * the function check url and if url match a rule defined value will be return.
 * If no rules matches false is return.
 * This function can be used in theme to change backgound or theme information
 * link to the browsing context.
 * @example
 * $myrules = array (array (array("key"=>"name", "value"=>"Section"),
 *                          array("key" =>" ", "value" =>" Section"),
 *                          "action"=>"<img src=\" images/toto. gif\" >"),
 *                   array(array ("key" =>"name", "value" =>" Section"),
 *                         array("key" =>" name","value" =>" Section"),
 *                       "action" =>"<img src=\" images/toto. gif\" >")));
 * @param rule array
 * @return action value if rule mactched or false if no be matched.
 */
function urlActionRule($rulesdef){
 global $_SERVER, $_REQUEST;

 foreach ($rulesdef as $rules) {
 	$rulesvalide=true;
 	foreach ($rules as $rule){
 		if ($rules["action"]!=$rule){
 			if ($rule["value"]!=$_REQUEST[$rule["key"]]){
 				$rulesvalide=false;
 			}
 		}
 	}
 	if  ($rulesvalide) return $rules["action"];
 }
 return false;
}
/**
 * buttonBar()
 * display a bar with generic action print,pdf,back,top.
 * this bar is associated to style defined in theme buttonBarIcon,
 * buttonBarTable, buttonBarTd, buttonBarTr, buttonBarDiv.
 * @example
 * $bardef=array("print"=>"modules.php?name=Sections&sop=printpage&amp;artid=$artid",
 * "pdf"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
 * "back"=>"modules.php? name=Sections&sop=printpage&amp;artid=$artid",
 * "mailto"=>"mailto:stephan@toto.com",
 * "top" =>" modules. php?name=Sections&sop=printpage&amp; artid=$artid" );
 * buttonBar ($bardef);
 * @param bar definition
 * @param align : horizontal bar, valign: vertical bar;
 */
function buttonBar($mybardef, $ori="align",$echonow=true, $ismobile=false){
	global $displayprint, $displaypdf, $displayback, $displaytop, $displaymailto, $Default_Theme, $displaycarnetvoyage;
	global $buttonBarElt;
	// default
	if ($mybardef["back"]=="") {$mybardef["back"]="#back"; $displayback=0;}
	if ($mybardef["top"]=="")  {$mybardef["top"]="#top"; $displaytop=0;};
	if ($mybardef["print"]==""){ $mybardef["print"]=""; $displayprint=0;}
	if ($mybardef["pdf"]==""){   $mybardef["pdf"]=""; $displaypdf=0;}
	if ($mybardef["mailto"]==""){   $mybardef["mailto"]=""; $displaymailto=0;}
	if ($mybardef["carnetvoyage"]==""){   $mybardef["carnetvoyage"]=""; $displaycarnetvoyage=0;}

	// get icone
	$printicone="themes/$Default_Theme/images/print.gif";
	if (!file_exists($printicone)) $printicone="images/print.gif";
	$pdficone="themes/$Default_Theme/images/pdf.gif";
	if (!file_exists($pdficone)) $pdficone="images/pdf.gif";
	$backicone="themes/$Default_Theme/images/back.gif";
	if (!file_exists($backicone)) $backicone="images/back.gif";
	$topicone="themes/$Default_Theme/images/top.gif";
	if (!file_exists($topicone)) $topicone="images/top.gif";
	$mailtoicone="themes/$Default_Theme/images/mailto.gif";
	if (!file_exists($mailtoicone)) $mailtoicone="images/mailto.gif";
	//$partageicone="themes/$Default_Theme/images/partage.gif";
	//if (!file_exists($partageicone)) $partageicone="images/partage.gif";

	if ($ori=="align") $ulclass="buttonBarUla"; else $ulclass="buttonBarUlv";
	
	$bbar = "<ul class=\"$ulclass\">";
	if ($displayback==1)  $bbar .= "<li><a href=\"".$mybardef["back"]."\" title=\""._BACKTO."\"><img src=\"$backicone\" border=\"0\" alt=\""._BACKTO."\"></a></li>";
	if ($displayprint==1) $bbar .= "<li><a href=\"".$mybardef["print"]."\" target=\"_blank\" title=\""._PRINTER."\"><img src=\"$printicone\" border=\"0\" alt=\""._PRINTER."\"></a></li>";
	if ($displaypdf==1)   $bbar .= "<li><a href=\"".$mybardef["pdf"]."\" target=\"_blank\" title=\""._PDF."\"><img src=\"$pdficone\" border=\"0\" alt=\""._PDF."\"></a></li>";
	//if ($displaymailto==1) $sortie .= "<li><a href=\"".$mybardef["mailto"]."\"><img src=\"$mailtoicone\" border=\"0\" alt=\""._MAILTO."\"></a></li>";
	if ($displaymailto==1) {
		if (!$ismobile) {
		$bbar .= "<li><a class=\"addthis_button\" href=\"http://www.addthis.com/bookmark.php?v=250&amp;username=goune\" title=\""._MAILTO."\"><img src=\"".$mailtoicone."\" alt=\""._MAILTO."\" style=\"border:0\"/></a><script type=\"text/javascript\" src=\"http://s7.addthis.com/js/250/addthis_widget.js#username=goune\"></script></li>";
		}
		else { //ce code sera utiise pour les versions mobiles des modules
			$bbar .= "<li><a class=\"addthis_button\" href=\"http://www.addthis.com/bookmark.php?v=250&amp;username=goune\" title=\""._MAILTO."\"><img src=\"".$mailtoicone."\" alt=\""._MAILTO."\" style=\"border:0\"/></a>
	<script type=\"text/javascript\" src=\"http://s7.addthis.com/js/250/addthis_widget.js#username=goune\"></script></li>";
		}
	}
	if ($displaytop==1)   $bbar .= "<li><a href=\"".$mybardef["top"]."\" title=\""._TOP."\"><img src=\"$topicone\" border=\"0\" alt=\""._TOP."\"></a></li>";
	if ($displaycarnetvoyage == 1 && is_active("SimpleTravelBook")) {
		require_once("modules/SimpleTravelBook/index.php");
		$bbar .= "<li id=\"carnetvoyage\">".$lecarnetvoyage."</li>";
	}
	$bbar .= "</ul>";

	$sortie =  "<div style=\"clear:both; height: 0; line-height:0; font-size:0\"></div><div class=\"buttonBarDiv\">";
	$sortie .= $bbar;
	$sortie .= "</div>";
	
	$buttonBarElt = "<div style=\"clear:both; height: 0; line-height:0; font-size:0\"></div><div class=\"buttonBarDivElt\">";
	$buttonBarElt .= $bbar;
	$buttonBarElt .= "</div>";
	
	if ($echonow) {
		echo $sortie;
	}
	else {
		return $sortie;
	}
}
/**
 * filter
 * clean code
 * @param
 * @param
 * @param
 * @copyright Copyright PHP NUKE 7.9
 */
function filter($what, $strip="", $save="", $type="") {
	if ($strip == "nohtml") {
		$what = check_html($what, $strip);
		$what = htmlentities(trim($what), ENT_QUOTES, "ISO-8859-1");
		// If the variable $what doesn't comes from a preview screen should be converted
		if ($type != "preview" AND $save != 1) {
			$what = html_entity_decode($what, ENT_QUOTES, "ISO-8859-1");
		}
	}
	if ($save == 1) {
		$what = check_words($what);
		$what = check_html($what, $strip);
		$what = addslashes($what);
	} else {
		$what = stripslashes(FixQuotes($what));
		$what = check_words($what);
		$what = check_html($what, $strip);
	}
	return($what);
}
/**
 * stripos_clone()
 * stripos alias for PHP Nuke 7.9> compatibility. ECMS run only with PHP5
 * this methode only exist on PHP5, Nuke 7.9 can run on PHP4
 *
 */
function stripos_clone($haystack, $needle, $offset=0) {
	return stripos($haystack, $needle, $offset=0);
}

/**
 * get_theme()
 *
 * @copyright Copyright PHP NUKE 7.9
 */
function get_theme() {
	global $user, $userinfo, $Default_Theme, $name, $op;
	if (isset($ThemeSelSave)) return $ThemeSelSave;
	if(is_user($user) && ($name != "Your_Account" && $op != "logout")) {
		getusrinfo($user);
		if(empty($userinfo['theme'])) $userinfo['theme']=$Default_Theme;
		if(file_exists("themes/".$userinfo['theme']."/theme.php")) {
			$ThemeSel = $userinfo['theme'];
		} else {
			$ThemeSel = $Default_Theme;
		}
	} else {
		$ThemeSel = $Default_Theme;
	}
	static $ThemeSelSave;
	$ThemeSelSave = $ThemeSel;
	return $ThemeSelSave;
}

function get_theme_mobile() {
	global $user, $userinfo, $Default_Theme_mobile, $name, $op;
	if (isset($ThemeSelSave)) return $ThemeSelSave;
	if(is_user($user) && ($name != "Your_Account" && $op != "logout")) {
		getusrinfo($user);
		if(empty($userinfo['theme'])) $userinfo['theme']=$Default_Theme;
		if(file_exists("themes/".$userinfo['theme']."/theme.php")) {
			$ThemeSel = $userinfo['theme'];
		} else {
			$ThemeSel = $Default_Theme_mobile;
		}
	} else {
		$ThemeSel = $Default_Theme_mobile;
	}
	static $ThemeSelSave;
	$ThemeSelSave = $ThemeSel;
	return $ThemeSelSave;
}

/**
 * is_group()
 * @param array user
 * @param string group title
 * @return return 1 if user is a group user
 */
function is_group($user, $name) {
	global $prefix, $db, $user_prefix, $cookie, $user;
	if (is_user($user)) {
		if(!is_array($user)) {
			$cookie = cookiedecode($user);
			$uid = intval($cookie[0]);
		} else {
			$uid = intval($user[0]);
		}
		$result = $db->sql_query("SELECT points FROM ".$user_prefix."_users WHERE uid='$uid'");
		list($points) = $db->sql_fetchrow($result);
		$points = intval($points);
		$db->sql_freeresult($result);
		$result2 = $db->sql_query("SELECT mod_group FROM ".$prefix."_modules WHERE title='$name'");
		list($mod_group) = $db->sql_fetchrow($result2);
		$mod_group = intval($mod_group);
		$db->sql_freeresult($result2);
		$result3 = $db->sql_query("SELECT points FROM ".$prefix."_groups WHERE id='$mod_group'");
		list($rpoints) = $db->sql_fetchrow($result3);
		$grp = intval($rpoints);
		$db->sql_freeresult($result3);
		if (($points >= 0 AND $points >= $grp) OR $mod_group == 0) {
			return 1;
		}
	}
	return 0;
}

/**
 * is_user_group()
 * @param groupid
 * @return boolean  true if current user is a groupid user else return false
 *
 */
function is_user_group($groupid){
	global $prefix, $db, $user_prefix, $cookie, $user;

	if (($groupid == "0")||($groupid == "")) { // All user
		return 1;
	} 
	elseif ((is_user($user))&&($groupid == "999")){ // registered user
		return 1;
	}
	elseif (is_user($user)) {
		if(!is_array($user)) {
			$cookie = cookiedecode($user);
			$uid = intval($cookie[0]);
		} else {
			$uid = intval($user[0]);
		}
		/*$result = $db->sql_query("SELECT points FROM ".$user_prefix."_users WHERE uid='$uid'");
		list($points) = $db->sql_fetchrow($result);
		$points = intval($points);
		$db->sql_freeresult($result);

		$result3 = $db->sql_query("SELECT points FROM ".$prefix."_groups WHERE id='$groupid'");
		list($rpoints) = $db->sql_fetchrow($result3);
		$grp = intval($rpoints);
		$db->sql_freeresult($result3);
		if ($points >= 0 AND $points >= $grp) {
			return 1;
		}*/
		$result = $db->sql_query("SELECT id FROM ".$user_prefix."users_groups WHERE user_id='$uid' AND group_id='$groupid';");
		if ($db->sql_numrows($result) > 0) {
		    return 1;
		}
	}
	return 0;
}

/**
 * get_group_name()
 * @param int group id
 * @return string group name
 *
 */
function get_group_name($groupid){
	global $prefix, $db;
	if ($groupid==0) {
		$gpname="ALL";
	} else if ($groupid==999){
		$gpname="RESGISTERED";
	} else {
		$result = $db->sql_query("SELECT name FROM ".$prefix."_groups WHERE id='$groupid'");
		list($gpname) = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);
	}
	return $gpname;
}


/**
 * get_user_group()
 * @return current user group id 999:registered 0:anomynous or group_id  *
 *
 */
function get_user_group(){
	global $prefix, $db, $user_prefix, $cookie, $user;
	$group_id=0;
	if (is_user($user)) {
		$group_id=999;
		if(!is_array($user)) {
			$cookie = cookiedecode($user);
			$uid = intval($cookie[0]);
		} else {
			$uid = intval($user[0]);
		}
		 
		$result = $db->sql_query("SELECT points FROM ".$user_prefix."_users WHERE uid='$uid'");
		list($points) = $db->sql_fetchrow($result);
		$points = intval($points);
		$db->sql_freeresult($result);
		$result = $db->sql_query("SELECT id FROM ".$prefix."_groups WHERE points >= $points");
		$grp_array = $db->sql_fetchrow($result);
		$db->sql_freeresult($result);
		sort($grp_array);
		if (sizeof($grp_array))$group_id = $grp_array[0];
	}
	return  $group_id;
}

/**
 * update_points($id)
 *
 *
 */
function update_points($id) {
	global $user_prefix, $prefix, $db, $user;
	if (is_user($user)) {
		if(!is_array($user)) {
			$cookie = cookiedecode($user);
			$username = trim($cookie[1]);
		} else {
			$username = trim($user[1]);
		}
		if ($db->sql_numrows($db->sql_query("SELECT * FROM ".$prefix."_groups")) > '0') {
			$id = intval($id);
			$result = $db->sql_query("SELECT points FROM ".$prefix."_groups_points WHERE id='$id'");
			list($points) = $db->sql_fetchrow($result);
			$db->sql_freeresult($result);
			$rpoints = intval($points);
			$db->sql_query("UPDATE ".$user_prefix."_users SET points=points+".$rpoints." WHERE username='$username'");
		}
	}
}

/**
 * checkModuleRight()
 * @param string module name
 * @return true the current authors can use and administrate the module else
 * return false
 */
function checkModuleRight($themodule) {
	global $prefix, $db, $aid;
	$aid = substr("$aid", 0,25);
	$row = $db->sql_fetchrow($db->sql_query("SELECT title, admins FROM ".$prefix."_modules WHERE title='$themodule'"));
	$row2 = $db->sql_fetchrow($db->sql_query("SELECT name, radminsuper FROM ".$prefix."_authors WHERE aid='$aid'"));
	$admins = explode(",", $row['admins']);
	$auth_user = 0;
	for ($i=0; $i < sizeof($admins); $i++) {
		if ($row2['name'] == "$admins[$i]" AND !empty($row['admins'])) {
			$auth_user = 1;
		}
	}

	if ($row2['radminsuper'] == 1 || $auth_user == 1) return true;

	return false;
}
/**
 * validate_mail()
 * verify email validity
 * @param email
 * @return display error or email if email is correct
 */
function validate_mail($email) {
	if(strlen($email) < 7 || !preg_match("/\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*/", $email)) {
		//include_once("header.php");
		//OpenTable();
		echo _ERRORINVEMAIL;
		//CloseTable();
		//include_once("footer.php");
	}
	else {
		return $email;
	}
}
/**
 * encode_mail()
 * @param email
 * @return encoded email
 */
function encode_mail($email) {
	$finished = "";
	for($i=0; $i<strlen($email); ++$i) {
		$n = mt_rand(0, 1);
		if($n) {
			$finished .= '&#x'.sprintf("%X",ord($email{$i})).';';
		}
		else {
			$finished .= '&#'.ord($email{$i}).';';
		}
	}
	return $finished;
}
/**
 * makePass()
 * make password
 * @return new password
 */
function makePass() {
	$cons = "bcdfghjklmnpqrstvwxyz";
	$vocs = "aeiou";
	for ($x=0; $x < 6; $x++) {
		mt_srand ((double) microtime() * 1000000);
		$con[$x] = substr($cons, mt_rand(0, strlen($cons)-1), 1);
		$voc[$x] = substr($vocs, mt_rand(0, strlen($vocs)-1), 1);
	}
	mt_srand((double)microtime()*1000000);
	$num1 = mt_rand(0, 9);
	$num2 = mt_rand(0, 9);
	$makepass = $con[0] . $voc[0] .$con[2] . $num1 . $num2 . $con[3] . $voc[3] . $con[4];
	return($makepass);
}
/**
 * adminEditButton()
 * check if current user is an admin and display a button to edit the current page
 * becarefull, if page where admin button is displayed already include overlib that will cause issues, in this case don't use second parameter
 * @param url admin link to the current page
 * @return true is current user is an admin
 */
function adminEditButton($adminurl,$messageToDisplay=""){
	global $admin;
	$popupinfo="";
	if ($messageToDisplay!="") {
		$popupinfo="onmouseover=\"return overlib('".$messageToDisplay."',WIDTH, 150, CENTER);\" onmouseout=\"return nd()\" ";
		$popupCode="<div id=\"overDiv\" style=\"position:absolute; visibility:hidden; z-index:1000;\"></div>\n";
		$popupCode.="<script language=\"JavaScript\" src=\"javascripts/overlib_mini.js\"></script>\n";
	}
	if (file_exists("images/edit16x16.png")){
		$editButton="<img src=\"images/edit16x16.png\" border=0 alt=\""._EDIT."\" title=\""._EDIT."\" $popupinfo>";
	} else {
		$editButton="["._EDIT."]";
	}
	if (is_admin($admin)) {
		echo $popupCode;
		echo "<script language=\"JavaScript\" src=\"javascripts/keyboard.js\"></script>\n";
		// Shift F2 keyboard shortcut to edit
		echo "<script language=\"JavaScript\">setKeyCodeUrl(113,'$adminurl');\n document.onkeydown = process_keypress;</script>\n";
		echo "<div class=adminBar><a href=\"$adminurl\">".$editButton."</a></div>";
	}
}
/**
 * setPath()
 * Add a level or update a level for the UI fonction path diplayed with the displayPath function
 * call to this method under a function must be done before include(header.html) call
 * @param string function string
 * @param int level
 * @param string url (option)
 * @return true id update is correct else return false
 * @see displayPath() function
 */
function setPath($textpath,$levelpath,$urlpath=""){
	session_start();
	if(! isset( $_SESSION['ecmspath'] ) ) {
		$_SESSION['ecmspath'] = array();
	}
	$myPath=$_SESSION['ecmspath'];
	array_splice ($myPath, $levelpath);
	$myPath[$levelpath]=array("text"=>$textpath,"url"=>$urlpath);
  
	$_SESSION['ecmspath']=$myPath;
	return true;
}
/**
 * displayPath()
 * display functionnality path
 * @return html string with the current path
 */
function displayPath(){
	session_start();
	$thePath="";
	if( isset( $_SESSION['ecmspath'] ) ) {
		$myPath=$_SESSION['ecmspath'];
		$thePath="<div class=systempath>";
		foreach ($myPath as $pathElement){
			$thePath.="/<a href=\"".$pathElement["url"]."\">".$pathElement["text"]."</a>";
		}
		$thePath.="</div>";
	}
	return $thePath;
}
/**
 * iniPath
 * initialyse en clean path
 *
 */
function initPath(){
	$_SESSION['ecmspath'] = array();
	return true;
}
/**
 * getlanlist()
 * provide available languages list present in language folder
 * by default (language folder) or for current module (_MODULE_LANG or 1) or for admin (_ADMIN_LANG  or 2)
 * @param int default=0, current_module=1 (_MODULE_LANG), admin language=2  (_ADMIN_LANG)
 * @return language list as array
 */
function getlanglist($langtype=0){
	global $module_name;
	if ($langtype==0) $lanpath="language";
	if ($langtype==1) $lanpath="$modules_name/language";
	if ($langtype==2) $lanpath="system/language";

	$handle=opendir($lanpath);
	while ($file = readdir($handle)) {
		if (preg_match("/^lang\-(.+)\.php/", $file, $matches)) {
			$langFound = $matches[1];
			$languageslist .= "$langFound ";
		}
	}
	closedir($handle);
	$languageslist = explode(" ", $languageslist);
	sort($languageslist);
	return $languageslist;
}
/**
 * check_Db()
 * check debconnection
 * @param table
 * @param attr
 * @param mesg if true display and an information message to user (default is true)
 * @return true if dbconnection is OK
 */
function check_Db($ctable,$cattr,$cmesg=true){
	global $db, $prefix;
	if (!$db || !isset($db)){
		if ($cmesg) ecms_user_msg(_NO_DB_connection);
		return false;
	}
	$result=$db->sql_query("select $cattr from ".$prefix."_$ctable  ");
	if ($result) {
		return true;
	} else {
		if ($cmesg) ecms_user_msg(_NO_DB_connection);
		return false;
	}
}
/**
 * ecms_user_msg()
 * display an user message
 *
 */
function  ecms_user_msg($msg){
	echo $msg;
}
/**
 * getBaseURL()
 * Returns the full absolute URL to the directory where
 * ECMS is installed
 * @return string ECMS base url string
 */
function getBaseURL(){

 if(substr($_SERVER['SCRIPT_NAME'],-4) == '.php'){
 	$dir = dirname($_SERVER['SCRIPT_NAME']).'/';
 }elseif(substr($_SERVER['PHP_SELF'],-4) == '.php'){
 	$dir = dirname($_SERVER['PHP_SELF']).'/';
 }elseif($_SERVER['DOCUMENT_ROOT'] && $_SERVER['SCRIPT_FILENAME']){
 	$dir = preg_replace ('/^'.preg_quote($_SERVER['DOCUMENT_ROOT'],'/').'/','',
 	$_SERVER['SCRIPT_FILENAME']);
 	$dir = dirname('/'.$dir).'/';
 }else{
 	$dir = './'; //probably wrong
 }
  
 $dir = str_replace('\\','/',$dir); #bugfix for weird WIN behaviour
 $dir = preg_replace('#//+#','/',$dir);
  
 //handle script in lib/exe dir
 $dir = preg_replace('!includes/$!','',$dir);
  
 //handle script in lib/plugins dir
 $dir = preg_replace('!core/.*$!','',$dir);

 //split hostheader into host and port
 list($host,$port) = explode(':',$_SERVER['HTTP_HOST']);
 if(!$port)  $port = $_SERVER['SERVER_PORT'];
 if(!$port)  $port = 80;
  
 // see if HTTPS is enabled - apache leaves this empty when not available,
 // IIS sets it to 'off', 'false' and 'disabled' are just guessing
 if (preg_match('/^(|off|false|disabled)$/i',$_SERVER['HTTPS'])){
 	$proto = 'http://';
 	if ($port == '80') {
 		$port='';
 	}
 }else{
 	$proto = 'https://';
 	if ($port == '443') {
 		$port='';
 	}
 }
  
 if($port) $port = ':'.$port;
  
 return $proto.$host.$port.$dir;
}
/**
 * get_style_path()
 * return path to css link to currents setting (current theme, current module, ...)
 * if no module style is not found return default style from the current theme.
 * @return css path.
 */
function get_style_path(){
	global $Default_Theme, $user, $name, $theme, $cookie;
	if(is_user($user)) {
		$user2 = base64_decode($user);
		$cookie = explode(":", $user2);
		if($cookie[9]=="") $cookie[9]=$Default_Theme;
		if(isset($theme)) $cookie[9]=$theme;
		if(!$file=@opendir("themes/$cookie[9]")) {
			$ThemeSel = $Default_Theme;
		} else {
			$ThemeSel = $cookie[9];
		}
	} else {
		$ThemeSel = $Default_Theme;
	}
	 
	$stylePath="themes/$ThemeSel/style/style.css";
	if (file_exists("themes/$ThemeSel/style/$name.css")){
		$stylePath= "themes/$Default_Theme/style/$name.css";
	} elseif (file_exists("modules/$name/css/default.css")) {
		$stylePath= "modules/$name/css/default.css";
	}

	return $stylePath;
}
/**
 * entity_to_decimal_value()
 * entity to unicode decimal value
 * @param string string to update
 */
function entity_to_decimal_value($string){

	$entity_to_decimal = array(
	'&nbsp;' => '&#160;',
	'&iexcl;' => '&#161;',
	'&cent;' => '&#162;',
	'&pound;' => '&#163;',
	'&curren;' => '&#164;',
	'&yen;' => '&#165;',
	'&brvbar;' => '&#166;',
	'&sect;' => '&#167;',
	'&uml;' => '&#168;',
	'&copy;' => '&#169;',
	'&ordf;' => '&#170;',
	'&laquo;' => '&#171;',
	'&not;' => '&#172;',
	'&shy;' => '&#173;',
	'&reg;' => '&#174;',
	'&macr;' => '&#175;',
	'&deg;' => '&#176;',
	'&plusmn;' => '&#177;',
	'&sup2;' => '&#178;',
	'&sup3;' => '&#179;',
	'&acute;' => '&#180;',
	'&micro;' => '&#181;',
	'&para;' => '&#182;',
	'&middot;' => '&#183;',
	'&cedil;' => '&#184;',
	'&sup1;' => '&#185;',
	'&ordm;' => '&#186;',
	'&raquo;' => '&#187;',
	'&frac14;' => '&#188;',
	'&frac12;' => '&#189;',
	'&frac34;' => '&#190;',
	'&iquest;' => '&#191;',
	'&Agrave;' => '&#192;',
	'&Aacute;' => '&#193;',
	'&Acirc;' => '&#194;',
	'&Atilde;' => '&#195;',
	'&Auml;' => '&#196;',
	'&Aring;' => '&#197;',
	'&AElig;' => '&#198;',
	'&Ccedil;' => '&#199;',
	'&Egrave;' => '&#200;',
	'&Eacute;' => '&#201;',
	'&Ecirc;' => '&#202;',
	'&Euml;' => '&#203;',
	'&Igrave;' => '&#204;',
	'&Iacute;' => '&#205;',
	'&Icirc;' => '&#206;',
	'&Iuml;' => '&#207;',
	'&ETH;' => '&#208;',
	'&Ntilde;' => '&#209;',
	'&Ograve;' => '&#210;',
	'&Oacute;' => '&#211;',
	'&Ocirc;' => '&#212;',
	'&Otilde;' => '&#213;',
	'&Ouml;' => '&#214;',
	'&times;' => '&#215;',
	'&Oslash;' => '&#216;',
	'&Ugrave;' => '&#217;',
	'&Uacute;' => '&#218;',
	'&Ucirc;' => '&#219;',
	'&Uuml;' => '&#220;',
	'&Yacute;' => '&#221;',
	'&THORN;' => '&#222;',
	'&szlig;' => '&#223;',
	'&agrave;' => '&#224;',
	'&aacute;' => '&#225;',
	'&acirc;' => '&#226;',
	'&atilde;' => '&#227;',
	'&auml;' => '&#228;',
	'&aring;' => '&#229;',
	'&aelig;' => '&#230;',
	'&ccedil;' => '&#231;',
	'&egrave;' => '&#232;',
	'&eacute;' => '&#233;',
	'&ecirc;' => '&#234;',
	'&euml;' => '&#235;',
	'&igrave;' => '&#236;',
	'&iacute;' => '&#237;',
	'&icirc;' => '&#238;',
	'&iuml;' => '&#239;',
	'&eth;' => '&#240;',
	'&ntilde;' => '&#241;',
	'&ograve;' => '&#242;',
	'&oacute;' => '&#243;',
	'&ocirc;' => '&#244;',
	'&otilde;' => '&#245;',
	'&ouml;' => '&#246;',
	'&divide;' => '&#247;',
	'&oslash;' => '&#248;',
	'&ugrave;' => '&#249;',
	'&uacute;' => '&#250;',
	'&ucirc;' => '&#251;',
	'&uuml;' => '&#252;',
	'&yacute;' => '&#253;',
	'&thorn;' => '&#254;',
	'&yuml;' => '&#255;',
	'&fnof;' => '&#402;',
	'&Alpha;' => '&#913;',
	'&Beta;' => '&#914;',
	'&Gamma;' => '&#915;',
	'&Delta;' => '&#916;',
	'&Epsilon;' => '&#917;',
	'&Zeta;' => '&#918;',
	'&Eta;' => '&#919;',
	'&Theta;' => '&#920;',
	'&Iota;' => '&#921;',
	'&Kappa;' => '&#922;',
	'&Lambda;' => '&#923;',
	'&Mu;' => '&#924;',
	'&Nu;' => '&#925;',
	'&Xi;' => '&#926;',
	'&Omicron;' => '&#927;',
	'&Pi;' => '&#928;',
	'&Rho;' => '&#929;',
	'&Sigma;' => '&#931;',
	'&Tau;' => '&#932;',
	'&Upsilon;' => '&#933;',
	'&Phi;' => '&#934;',
	'&Chi;' => '&#935;',
	'&Psi;' => '&#936;',
	'&Omega;' => '&#937;',
	'&alpha;' => '&#945;',
	'&beta;' => '&#946;',
	'&gamma;' => '&#947;',
	'&delta;' => '&#948;',
	'&epsilon;' => '&#949;',
	'&zeta;' => '&#950;',
	'&eta;' => '&#951;',
	'&theta;' => '&#952;',
	'&iota;' => '&#953;',
	'&kappa;' => '&#954;',
	'&lambda;' => '&#955;',
	'&mu;' => '&#956;',
	'&nu;' => '&#957;',
	'&xi;' => '&#958;',
	'&omicron;' => '&#959;',
	'&pi;' => '&#960;',
	'&rho;' => '&#961;',
	'&sigmaf;' => '&#962;',
	'&sigma;' => '&#963;',
	'&tau;' => '&#964;',
	'&upsilon;' => '&#965;',
	'&phi;' => '&#966;',
	'&chi;' => '&#967;',
	'&psi;' => '&#968;',
	'&omega;' => '&#969;',
	'&thetasym;' => '&#977;',
	'&upsih;' => '&#978;',
	'&piv;' => '&#982;',
	'&bull;' => '&#8226;',
	'&hellip;' => '&#8230;',
	'&prime;' => '&#8242;',
	'&Prime;' => '&#8243;',
	'&oline;' => '&#8254;',
	'&frasl;' => '&#8260;',
	'&weierp;' => '&#8472;',
	'&image;' => '&#8465;',
	'&real;' => '&#8476;',
	'&trade;' => '&#8482;',
	'&alefsym;' => '&#8501;',
	'&larr;' => '&#8592;',
	'&uarr;' => '&#8593;',
	'&rarr;' => '&#8594;',
	'&darr;' => '&#8595;',
	'&harr;' => '&#8596;',
	'&crarr;' => '&#8629;',
	'&lArr;' => '&#8656;',
	'&uArr;' => '&#8657;',
	'&rArr;' => '&#8658;',
	'&dArr;' => '&#8659;',
	'&hArr;' => '&#8660;',
	'&forall;' => '&#8704;',
	'&part;' => '&#8706;',
	'&exist;' => '&#8707;',
	'&empty;' => '&#8709;',
	'&nabla;' => '&#8711;',
	'&isin;' => '&#8712;',
	'&notin;' => '&#8713;',
	'&ni;' => '&#8715;',
	'&prod;' => '&#8719;',
	'&sum;' => '&#8721;',
	'&minus;' => '&#8722;',
	'&lowast;' => '&#8727;',
	'&radic;' => '&#8730;',
	'&prop;' => '&#8733;',
	'&infin;' => '&#8734;',
	'&ang;' => '&#8736;',
	'&and;' => '&#8743;',
	'&or;' => '&#8744;',
	'&cap;' => '&#8745;',
	'&cup;' => '&#8746;',
	'&int;' => '&#8747;',
	'&there4;' => '&#8756;',
	'&sim;' => '&#8764;',
	'&cong;' => '&#8773;',
	'&asymp;' => '&#8776;',
	'&ne;' => '&#8800;',
	'&equiv;' => '&#8801;',
	'&le;' => '&#8804;',
	'&ge;' => '&#8805;',
	'&sub;' => '&#8834;',
	'&sup;' => '&#8835;',
	'&nsub;' => '&#8836;',
	'&sube;' => '&#8838;',
	'&supe;' => '&#8839;',
	'&oplus;' => '&#8853;',
	'&otimes;' => '&#8855;',
	'&perp;' => '&#8869;',
	'&sdot;' => '&#8901;',
	'&lceil;' => '&#8968;',
	'&rceil;' => '&#8969;',
	'&lfloor;' => '&#8970;',
	'&rfloor;' => '&#8971;',
	'&lang;' => '&#9001;',
	'&rang;' => '&#9002;',
	'&loz;' => '&#9674;',
	'&spades;' => '&#9824;',
	'&clubs;' => '&#9827;',
	'&hearts;' => '&#9829;',
	'&diams;' => '&#9830;',
	'&quot;' => '&#34;',
	'&amp;' => '&#38;',
	'&lt;' => '&#60;',
	'&gt;' => '&#62;',
	'&OElig;' => '&#338;',
	'&oelig;' => '&#339;',
	'&Scaron;' => '&#352;',
	'&scaron;' => '&#353;',
	'&Yuml;' => '&#376;',
	'&circ;' => '&#710;',
	'&tilde;' => '&#732;',
	'&ensp;' => '&#8194;',
	'&emsp;' => '&#8195;',
	'&thinsp;' => '&#8201;',
	'&zwnj;' => '&#8204;',
	'&zwj;' => '&#8205;',
	'&lrm;' => '&#8206;',
	'&rlm;' => '&#8207;',
	'&ndash;' => '&#8211;',
	'&mdash;' => '&#8212;',
	'&lsquo;' => '&#8216;',
	'&rsquo;' => '&#8217;',
	'&sbquo;' => '&#8218;',
	'&ldquo;' => '&#8220;',
	'&rdquo;' => '&#8221;',
	'&bdquo;' => '&#8222;',
	'&dagger;' => '&#8224;',
	'&Dagger;' => '&#8225;',
	'&permil;' => '&#8240;',
	'&lsaquo;' => '&#8249;',
	'&rsaquo;' => '&#8250;',
	'&euro;' => '&#8364;');

	return preg_replace(
	"/&[A-Za-z]+;/",
	" ",
	strtr($string,$entity_to_decimal) );

}
/**
 * setHeader
 */
function setHeader($hcontent){
 $_headerContent = $hcontent;
}
/**
 * write_to_log
 */
function write_to_log($Id,$date,$aid,$module,$operation) {
	global $db,$prefix,$module_name,$aid ;
	if ($date == "") {
		$date = date("Y-m-d H:i:s");
	}
	if ($aid == "") {
		$aid = "inconnu";
	}
	if ($module == "") {
		$module = $module_name;
	}
	$name_module = "";
	$result_tab = $db->sql_query("SELECT custom_title FROM ".$prefix."_modules WHERE title='".$module."';");
	list($name_module) = $db->sql_fetchrow($result_tab);
	if ($name_module == "") {
		$name_module = $module;
	}
	if ($Id == "-1" || $Id == "") {
		$sql = "INSERT INTO ".$prefix."_log_file (`date`,`aid`,`module`,`name_module`,`operation`)";
		$sql .= " VALUES ('".$date."','".$aid."','".$module."','".$name_module."','".$operation."');";
	}
	else {
		$sql = "UPDATE ".$prefix."_log_file SET `date` = '".$date."',`aid` = '".$aid."',`module` = '".$module."',`name_module` = '".$name_module."', `operation` = '".$operation."' WHERE `Id` = '".$Id."';";
	}
	return $db->sql_query($sql);
}
/**
 * normalize_name
 */
function normalize_name($chaine)
{
	$chaine = preg_replace("#[^A-Za-z0-9\ ]#i","",$chaine);
	$from = ' ';
	$to = 'aaaaaaaaaaaaaacceeeeeeeeiiiiiiiinnoooooooooouuuuuuuuy_';
	return strtr($chaine, $from, $to);
}

function str_chiffrer($plaintext) {
	$key = pack('H*', "bcb04b7e103a1cd8b54763051cef08bc57abe029fdebae5e1d417e2ff02a00a3");
	$key_size =  strlen($key);
	$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC);
	$iv = mcrypt_create_iv($iv_size, MCRYPT_RAND);
	$ciphertext = mcrypt_encrypt(MCRYPT_RIJNDAEL_128, $key, $plaintext, MCRYPT_MODE_CBC, $iv);
	$ciphertext = $iv . $ciphertext;
	$ciphertext_base64 = base64_encode($ciphertext);
	return $ciphertext_base64;
}

function str_dechiffrer($ciphertext_base64) {
	$key = pack('H*', "bcb04b7e103a1cd8b54763051cef08bc57abe029fdebae5e1d417e2ff02a00a3");
	$iv_size = mcrypt_get_iv_size(MCRYPT_RIJNDAEL_128, MCRYPT_MODE_CBC);
	$ciphertext_dec = base64_decode($ciphertext_base64);
	$iv_dec = substr($ciphertext_dec, 0, $iv_size);
	$ciphertext_dec = substr($ciphertext_dec, $iv_size);
	$plaintext_dec = mcrypt_decrypt(MCRYPT_RIJNDAEL_128, $key, $ciphertext_dec, MCRYPT_MODE_CBC, $iv_dec);
	return rtrim($plaintext_dec, "\0");
}
?>