<?php
/************************************************************************/
/* BALISTE ECMS                                                         */
/* ===========================                                          */
/* Copyright (c) 2004 by Stephan Acquatella (stephan@balistis.com)      */
/* http://www.baliste.org                                               */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/

/**
 * class logger for Balistis ECMS dev with PHP5
 * @abstract
 * $include("core/becms_logger_class.php");
 * $trace=new logger(); or new loggerOff() loggerOff is a blanck class just for performances (i hope)
 * $
 * ..
 * $trace->trace("your text");
 */
class logger {
 private $log_file = "logs/baliste.log";
 private $address = "127.0.0.1";
 private $port = 7000;
 private $isFileLog=true;
 private $isNetLog=false;
 private $isWebLog=false;


 /**
  * constructor
  *
  */
 function _construct($log_file){
 $this->log_file=$log_file;
 }
 /**
  * trace()
  * display trace in logfile or network or web server log file
  */
 public function trace($mess){
   $bt = debug_backtrace();
   // get class, function called by caller of caller of caller
   $class = $bt[2]['class'];
   $function = $bt[2]['function'];
   // get file, line where call to caller of caller was made
   $file = $bt[1]['file'];
   $line = $bt[1]['line'];
   $date = date('[Y-m-d h:i:s]');

   $mymess = "[ECMS] $date-> $class :: $function :: $file :: $line\n";
   
   if (is_array($mess)) $mess=print_r($mess, true);
   $mymess.= "=> $mess \n";

  if ($this->isFileLog) error_log($mymess, 3, $this->log_file);
  if ($this->isNetLog) error_log($mymess, 3, "".$this->address.":".$this->port."");
  if ($this->isWebLog) error_log($mymess, 0);

 }
/**
 * gettrace()
 * provide last trace
 *
 */
public function gettrace(){}

/**
 * setFile
 * @param boolean
 * @return no return
 */
public function setFileLog($st){
$this->isFileLog=$st;
}
/**
 * setNetLog
 * @param boolean
 * @return no return
 */
public function setNetLog($st){
$this->isNetLog=$st;
}
/**
 * setWebLog
 * @param boolean
 * @return no return
 */
public function setWebLog($st){
$this->isWebLog=$st;
}
} // end class

/**
 * Class loggerOff
 * @abstract blanck class
 */
class loggerOff {
public function trace($mess){}
public function gettrace(){}
public function setFileLog($st){}
public function setNetLog($st){}
public function setWebLog($st){}
}

?>