<?php
/**
 * Classes des fonctions pour afficher les clients.
 *
 * Elles sont dans une classe pour les isoler des autres fonctions.
 * @package becmsSimpleClient
 * @version 0.1
 * @author Vincent RUIZ <webmaster@arobase.fr>
 * @copyright Copyright  2007, Vincent RUIZ
 * @license http://opensource.org/licenses/gpl-license.php GNU Public License
 */
require_once("g_db.php");
require_once("ba_adminsudoku.php");

/**
 * Classe des fonctions.
 *
 * @package becmsSimpleClient
 */
class displaySudokus {

	/**
	 * @var object Classe qui donne accs au fonctions de manipulation des clients.
	 */
	var $sgbd;
	/**
	 * @var object Classe qui donne accs au fonctions de manipulation des clients.
	 */
	var $sgbd_client;
	/**
	 * Initialise $sgbd avec la classe des fonctions d'accs  la base de donnes des clients.
	 */
	function displaySudokus() {
		$this->sgbd = new BD_Sudoku();
		$this->sgbd_client = new BD_Clients();
	}

	/**
	 * Construit la liste des clients retrouvs.
	 *
	 * Renvoie le code HTML de la liste des clients.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @param array $criteres Tableau contenant les paramtres d'affichage.
	 * @return string Liste HTML des clients.
	 */
	function get_list_sudokus($My_SQL,$vars_mod,$criteres) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylesudoku = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		else {
			$stylesudoku = '		<link href="'.$vars_mod["cheminModule"].'lib/style-sudoku.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$admin = new adminSudoku();
		
		if ($vars_mod[$vars_mod["leniveau"]] != 0) {
			$niv_search_inf = ceil(($vars_mod[$vars_mod["leniveau"]]-1)*1000/7)+1;
			$niv_search_sup = ceil(($vars_mod[$vars_mod["leniveau"]]+0)*1000/7);
		}
		else {
			$niv_search_inf = "";
			$niv_search_sup = "";
		}
		$nbreFiches = $this->sgbd->getNumSudokus($My_SQL,"",$niv_search_inf,$niv_search_sup);
		$repParPage = $criteres["sudokus_par_page"];
		$p = $criteres["page_en_cours"];
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$limInf = ($p-1)*$repParPage;
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._SUDOKUFOUNDPAGES;
			$indexPages .= _SUDOKUPAGES;
			for ($i=1;$i<=$nbrepages;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?".$admin->getVars($vars_mod["page_en_cours"])."&".$vars_mod["page_en_cours"]."=$i\">$i</a>";
					$indexPages .= "</div>";
				}
			}
		}
		else {
			$indexPages .= _SUDOKUNOTFOUNDPAGES;
		}
		$indexPages .= "</div>";
			
		
		$sudokus = $this->sgbd->getSudokus($My_SQL,"","",$limInf.",".$repParPage,$niv_search_inf,$niv_search_sup);
		if (count($sudokus) != 0) {
			$listsudokus = "<ul class=\"listegrille\">";
			foreach ($sudokus as $sudoku) {
				//$sudoku_ligne = $sudoku["Id"]." - ".$sudoku["niveau"]." - ".$admin->date2JMA($sudoku["date"]);
				$sudoku_ligne = "N".$sudoku["Id"]." - Niveau ".ceil($sudoku["niveau"]*7/1000);
				$sudoku_grille = $admin->display_sudokus_grid($sudoku["grille"],$sudoku["masque"]);
				$listsudokus .= "<li><a href=\"modules.php?name=Sudoku&sop=display&id_sudoku=".$sudoku["Id"]."\">".$admin->conditionnerHTML($sudoku_ligne)."</a><br />".$sudoku_grille."</li>";
			}
			$listsudokus .= "</ul>";
		}
		else {
			$listsudokus = "";
		}
		
		$block_search = '
		<form name="search_article" method="post" action="modules.php?name='.$module_name.'&sop=search">
		<div align="center">
		<fieldset class="noprint"><legend>'._SUDOKUFORMSEARCH.'</legend>
		<div align="center" id="mySudoku">
		<select name="'.$vars_mod["leniveau"].'" size="1">
		<option value="">Niveau des grilles</option>
		';
		for ($i=1;$i<7;$i++){
			$block_search .= '<option value="'.$i.'"'.$this->test_select($vars_mod[$vars_mod["leniveau"]],$i).'>Niveau '.$i.'</option>
			';
		}
		
		$block_search .= '<option value="7"'.$this->test_select($vars_mod[$vars_mod["leniveau"]],7).'>Diabolique</option>
		</select>
		<input type="submit" value="'._SUDOKUSEARCH.'" class="margin" style="margin-bottom: 0">
		</div>
		</fieldset>
		</div>
		</form>
		';
		
		$contenu = '
		'.$stylesudoku.'
		<div class="sudokus">
			<h1>'._AVAILABLESUDOKUS.'</h1>
			'.$block_search.'
			'.$indexPages.'
			'.$listsudokus.'
		</div>';
			
		return $contenu;
	}
	
	/**
	 * Revoie "selected" si les deux valeurs sont gales.
	 * @param string $valeur1 Valeur  comparer.
	 * @param string $valeur2 Seconde valeur  comparer.
	 * @return string "seleted" ou rien.
	 */
	function test_select($valeur1,$valeur2) {
		if ($valeur1 == $valeur2) {
			return ' selected="selected"';
		}
		else {
			return "";
		}
	}

	/**
	 * Affiche la grille de sudoku dsigne.
	 *
	 * Renvoie le code HTML de la grille de sudoku jouable.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Fiche HTML du sudoku.
	 */
	function get_one_sudoku($My_SQL,$vars_mod) {
		global $module_name;

		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylesudoku = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		else {
			$stylesudoku = '		<link href="'.$vars_mod["cheminModule"].'lib/style-sudoku.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$admin = new adminSudoku();
		$sudokus = $this->sgbd->getSudokus($My_SQL,$vars_mod["id_sudoku"],"");
		if (count($sudokus) != 0) {
			$row = $sudokus[0];
			$row["id_sudoku"] = $row["Id"];

			$id_sudoku = $row["id_sudoku"];
			$id_client = "12";
			$grille_init = $row["grille"];
			$masque_init = $row["masque"];

			$sortie =  "<script type=\"text/javascript\">";
			$sortie .= "var sudoku = new Array(9);";
			for($i=0; $i<=8; $i++) {
				$sortie .= "sudoku[".($i+1)."] = new Array(9);";
				for ($j=0; $j<=8; $j++)
				$sortie .= "sudoku[".($i+1)."][".($j+1)."] = ".substr($row["grille"], $j+(9*$i), 1).";";
			}
			$sortie .= "</script>";

			$sortie .= '
	<link href="'.$vars_mod["cheminModule"].'lib/style-chiffres.css" rel="stylesheet" type="text/css" media="all" />
	<script type="text/javascript" src="'.$vars_mod["cheminModule"].'lib/lib_sudoku.js"></script>
	<script type="text/javascript" src="'.$vars_mod["cheminModule"].'lib/lib_autostart.js"></script>
	<script type="text/javascript" src="'.$vars_mod["cheminModule"].'lib/lib_chiffres.js"></script>
	<script type="text/javascript">
	// <![CDATA[
		addToStart(newPopUpChiffre);
	// ]]>
	</script>
	<form action="modules.php?name='.$module_name.'&sop=save" method="post" name="grilleform">
	<center>
	<table cellpadding="0" cellspacing="0" border="0"><tr>
	<td><div id="mySudoku">
	';
			for($i=0; $i<=8; $i++) {
				for($j=0; $j<=8; $j++) {
					$Masque[$i+1][$j+1] = substr($row['masque'], $j+(9*$i), 1);
					$Grille[$i+1][$j+1] = substr($row['grille'], $j+(9*$i), 1);
				}
			}
			$sortie .= "<table>\n";
			for($i=1; $i<=9; $i++) {
				$sortie .= "<tr>\n";
				for($j=1; $j<=9;$j++) {
					if($j==4 || $j==7) { // on rajoute une bordure  gauche des cases de la 4 et 7me colonne
						if($i==4 || $i==7) // on rajoute une bordure en haut des cases de la 4 et 7me ligne
						$case_class = 'borderLeftTop';
						else
						$case_class = 'borderLeft';
					} else {
						if($i==4 || $i==7) // on rajoute une bordure en haut des cases de la 4 et 7me ligne
						$case_class = 'borderTop';
						else
						$case_class = '';
					}

					if ($Masque[$i][$j]== 0)
					$sortie .= '<td class="'.$case_class.'"><input type="text" id="case_'.$i.'_'.$j.'" maxlength="1" value="" style="font-weight:bold;color:blue;" onfocus="showPopUpChiffres(this)" /></td>'."\n";
					else
					$sortie .= '<td class="'.$case_class.'"><input type="text" id="case_'.$i.'_'.$j.'" maxlength="1" value="'.$Grille[$i][$j].'" readonly="readonly" /></td>'."\n";
				}
				$sortie .= "</tr>\n";
			}
			$sortie .= "</table>\n";
			/*if (isset($_GET['id_sudoku'])) {
				$actionnew = "location.href='sudoku.php'";
			}
			else {
				$actionnew = "window.location.reload()";
			}*/
			$sortie .= '</div></td><td width="20"></td><td><div style="width:150px" id="mySudoku">
<center><b>'."N".$row["Id"]." - Niveau ".ceil($row["niveau"]*7/1000).'</b><br />&nbsp;</center>
<p>
<input type="hidden" name="mygrille" id="mygrille" value="'.$row['grille'].'" />
<input type="hidden" name="mymask" id="mymask" value="'.$row['masque'].'" />
<input type="hidden" name="'.$vars_mod["id_client"].'" id="'.$vars_mod["id_client"].'" value="'.$_SESSION["s_id_client"].'" />
<input type="hidden" name="id_sudoku" id="id_sudoku" value="'.$row['Id'].'" />
<input type="button" value="Afficher les erreurs" onclick="showErrors();" class="margin" /><br />
<input type="button" value="Indice" onclick="giveHint();" class="margin" /><br />
<input type="button" value="Recommencer" onclick="retry();" class="margin" /><br />
<input type="button" value="Solution" onclick="giveSolution();" class="margin" /><br />
&nbsp;<br />
<input type="button" value="Nouveau" onclick="newSudoku()" class="margin" /><br />
&nbsp;<br />
<input type="button" value="Sauvegarder" onclick="writeGrille(this.form);" class="margin" />
</p>
</div>
</td></tr></table>
</center>
</form>
';

		}
		$contenu = '
'.$stylesudoku.'
<div class="sudokus">
<h1>'._ONESUDOKU.'</h1>
<p>'.nl2br($admin->conditionnerHTML(_HOWTOPLAYSUDOKU)).'<br>&nbsp;</p>
'.$sortie.'</div>';
		return $contenu;
	}

	/**
	 * Affiche la grille de sudoku dsigne.
	 *
	 * Renvoie le code HTML de la grille de sudoku jouable.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Fiche HTML du sudoku.
	 */
	function get_one_party_sudoku($My_SQL,$vars_mod) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylesudoku = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		else {
			$stylesudoku = '		<link href="'.$vars_mod["cheminModule"].'lib/style-sudoku.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$sortie = "";
		$date_sauvegarde = "";
		$admin = new adminSudoku();
		if ($vars_mod["id_partie_sudoku"] != "-1") {
			$parties = $this->sgbd->getPartiesSudoku($My_SQL,$vars_mod["id_partie_sudoku"],"","","","");
		}
		else {
			$parties = $this->sgbd->getPartiesSudoku($My_SQL,"",$vars_mod["id_sudoku"],$vars_mod[$vars_mod["id_client"]],"","");
		}
		
		if (count($parties) != 0) {
			$partie = $parties[0];
			$date_sauvegarde = $admin->date2JMA($partie["date"]);
			$sudokus = $this->sgbd->getSudokus($My_SQL,$partie["id_sudoku"],"");
			if (count($sudokus) != 0) {
				$row = $sudokus[0];
				$row["id_sudoku"] = $row["Id"];

				$id_sudoku = $row["id_sudoku"];
				$id_client = "12";
				$grille_init = $row["grille"];
				$masque_init = $row["masque"];

				$sortie =  "<script type=\"text/javascript\">";
				$sortie .= "var sudoku = new Array(9);";
				for($i=0; $i<=8; $i++) {
					$sortie .= "sudoku[".($i+1)."] = new Array(9);";
					for ($j=0; $j<=8; $j++)
					$sortie .= "sudoku[".($i+1)."][".($j+1)."] = ".substr($row["grille"], $j+(9*$i), 1).";";
				}
				$sortie .= "</script>";

				$sortie .= '
	<link href="'.$vars_mod["cheminModule"].'lib/style-chiffres.css" rel="stylesheet" type="text/css" media="all" />
	<script type="text/javascript" src="'.$vars_mod["cheminModule"].'lib/lib_sudoku.js"></script>
	<script type="text/javascript" src="'.$vars_mod["cheminModule"].'lib/lib_autostart.js"></script>
	<script type="text/javascript" src="'.$vars_mod["cheminModule"].'lib/lib_chiffres.js"></script>
	<script type="text/javascript">
	// <![CDATA[
		addToStart(newPopUpChiffre);
	// ]]>
	</script>
	<form action="modules.php?name='.$module_name.'&sop=save" method="post" name="grilleform">
	<center>
	<table cellpadding="0" cellspacing="0" border="0"><tr>
	<td><div id="mySudoku">
	';
				for($i=0; $i<=8; $i++) {
					for($j=0; $j<=8; $j++) {
						$Masque[$i+1][$j+1] = substr($row['masque'], $j+(9*$i), 1);
						$Grille[$i+1][$j+1] = substr($row['grille'], $j+(9*$i), 1);
					}
				}

				for($i=0; $i<=8; $i++) {
					for($j=0; $j<=8; $j++) {
						$Masque_partie[$i+1][$j+1] = substr($partie['masque_utilisateur'], $j+(9*$i), 1);
						$Grille_partie[$i+1][$j+1] = substr($partie['grille_utilisateur'], $j+(9*$i), 1);
					}
				}

				/*
				 *
				 * case "blue": mymask.value += "1"; break;
				 case "red" : mymask.value += "2"; break;
				 case "green" : mymask.value += "3"; break;
				 case "orange" : mymask.value+="4"; break;
				 case "magenta" : mymask.value +="5"; break;
				 */

				$sortie .= "<table>\n";
				for($i=1; $i<=9; $i++) {
					$sortie .= "<tr>\n";
					for($j=1; $j<=9;$j++) {
						if($j==4 || $j==7) { // on rajoute une bordure  gauche des cases de la 4 et 7me colonne
							if($i==4 || $i==7) // on rajoute une bordure en haut des cases de la 4 et 7me ligne
							$case_class = 'borderLeftTop';
							else
							$case_class = 'borderLeft';
						} else {
							if($i==4 || $i==7) // on rajoute une bordure en haut des cases de la 4 et 7me ligne
							$case_class = 'borderTop';
							else
							$case_class = '';
						}
						switch ($Masque_partie[$i][$j]) {
							case "0" :
								$style = ' style="color: black"';
								$read = ' readonly="readonly"';
								break;
							case "1" :
								$style = ' style="font-weight:bold; color: blue"';
								$read = '';
								break;
							case "2" :
								$style = ' style="font-weight:bold; color: red"';
								$read = '';
								break;
							case "3" :
								$style = ' style="font-weight:bold; color: green"';
								$read = '';
								break;
							case "4" :
								$style = ' style="font-weight:bold; color: orange"';
								$read = '';
								break;
							case "5" :
								$style = ' style="font-weight:bold; color: magenta"';
								$read = '';
								break;
						}
						if ($Grille_partie[$i][$j]== 0)
						$sortie .= '<td class="'.$case_class.'"><input type="text" id="case_'.$i.'_'.$j.'" maxlength="1" value="" style="font-weight: bold; color: blue;" onfocus="showPopUpChiffres(this)" /></td>'."\n";
						else
						$sortie .= '<td class="'.$case_class.'"><input type="text" id="case_'.$i.'_'.$j.'" maxlength="1" value="'.$Grille_partie[$i][$j].'"'.$style.$read.' /></td>'."\n";
					}
					$sortie .= "</tr>\n";
				}
				$sortie .= "</table>\n";
				/*if (isset($_GET['id_sudoku'])) {
					$actionnew = "location.href='sudoku.php'";
				}
				else {
					$actionnew = "window.location.reload()";
				}*/
				$sortie .= '</div></td><td width="20"></td><td><div style="width:150px" id="mySudoku">
<center><b>'."N".$row["Id"]." - Niveau ".ceil($row["niveau"]*7/1000).'</b><br />&nbsp;</center>
<p>
<input type="hidden" name="mygrille" id="mygrille" value="'.$row['grille'].'" />
<input type="hidden" name="mymask" id="mymask" value="'.$row['masque'].'" />
<input type="hidden" name="'.$vars_mod["id_client"].'" id="'.$vars_mod["id_client"].'" value="'.$_SESSION["s_id_client"].'" />
<input type="hidden" name="id_sudoku" id="id_sudoku" value="'.$row['Id'].'" />
<input type="button" value="Afficher les erreurs" onclick="showErrors();" class="margin" /><br />
<input type="button" value="Indice" onclick="giveHint();" class="margin" /><br />
<input type="button" value="Recommencer" onclick="retry();" class="margin" /><br />
<input type="button" value="Solution" onclick="giveSolution();" class="margin" /><br />
&nbsp;<br />
<input type="button" value="Nouveau" onclick="newSudoku()" class="margin" /><br />
&nbsp;<br />
<input type="button" value="Sauvegarder" onclick="writeGrille(this.form);" class="margin" />
</p>
</div>
</td></tr></table>
</center>
</form>
';
			}
		}
		$contenu = '
'.$stylesudoku.'
<div class="sudokus">
<h1>'._ONESUDOKU.'</h1>
<p>'.nl2br($admin->conditionnerHTML(_HOWTOPLAYSUDOKU)).'<br>&nbsp;</p>
<p align="center">'._LASTSAVESUDOKU.$date_sauvegarde.'<br>&nbsp;</p>
'.$sortie.'</div>';
		return $contenu;
	}

	/**
	 * Affiche les parties enregistres de l'utilisateur en cours.
	 *
	 * Renvoie le code HTML des grille de sudoku enregistres.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @param array $criteres Tableau contenant les paramtres d'affichage.
	 * @return string Grille HTML des sudokus.
	 */
	function get_my_parties_sudoku($My_SQL,$vars_mod,$criteres) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylesudoku = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		else {
			$stylesudoku = '		<link href="'.$vars_mod["cheminModule"].'lib/style-sudoku.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$sortie = "";
		$date_sauvegarde = "";
		$admin = new adminSudoku();
		
		$nbreFiches = $this->sgbd->getNumParties($My_SQL,"",$_SESSION["s_id_client"]);
		$repParPage = $criteres["sudokus_par_page"];
		$p = $criteres["page_en_cours"];
		$nbrepages = ceil($nbreFiches/$repParPage);
		if ($p>$nbrepages) {
			$p = $nbrepages;
		}
		$limInf = ($p-1)*$repParPage;
		$indexPages .= "<div class=\"pages\">";
		if ($nbreFiches != 0) {
			$indexPages .= $nbreFiches._SUDOKUFOUNDPAGES;
			$indexPages .= _SUDOKUPAGES;
			for ($i=1;$i<=$nbrepages;$i++) {
				if ($i == $p ) {
					$indexPages .= "<div class=\"pagevide\">";
					$indexPages .= "$i";
					$indexPages .= "</div>";
				}
				else {
					$indexPages .= "<div class=\"page\">";
					$indexPages .= "<a href=\"?".$admin->getVars($vars_mod["page_en_cours"])."&".$vars_mod["page_en_cours"]."=$i\">$i</a>";
					$indexPages .= "</div>";
				}
			}
		}
		else {
			$indexPages .= _SUDOKUNOTFOUNDPAGES;
		}
		$indexPages .= "</div>";
		
		$parties = $this->sgbd->getPartiesSudoku($My_SQL,"","",$_SESSION["s_id_client"],"",$limInf.",".$repParPage);
		if (count($parties) != 0) {
			$listsudokus = "<ul class=\"listepartie\">";
			foreach($parties as $partie) {
				$sudokus = $this->sgbd->getSudokus($My_SQL,$partie["id_sudoku"]);
				if (count($sudokus) != 0) {
					$sudoku = $sudokus[0];
				}
				else {
					$sudoku= array("niveau" => "?");
				}
				$sudoku_ligne = "N ".$sudoku["Id"]." - Niveau ".ceil($sudoku["niveau"]*7/1000)."<br />".$admin->date2JMA($partie["date"]);
				$sudoku_grille = $admin->display_sudokus_partie_grid($partie["grille_utilisateur"],$partie["masque_utilisateur"]);
				$listsudokus .= "<li><a href=\"modules.php?name=Sudoku&sop=play_my_grid&id_partie_sudoku=".$partie["Id"]."\">".$admin->conditionnerHTML($sudoku_ligne)."</a><br />".$sudoku_grille."</li>";
			}
			$listsudokus .= "</ul>";
		}
		else {
			$listsudokus = _NOSAVEDSUDOKU;
		}
		$contenu = '
		'.$stylesudoku.'
		<div class="sudokus">
			<h1>'._MYSUDOKUS.'</h1>
			'.$indexPages.'
			'.$listsudokus.'
		</div>';
		return $contenu;
	}
	
	/**
	 * Enregistre la partie en cours.
	 *
	 * Renvoie le code HTML de la grille de sudoku jouable enregistre.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @param  array $my_grille Tableau contenant la partie en cours
	 * @return string Fiche HTML du sudoku en cours.
	 */
	function save_my_sudoku($My_SQL,$vars_mod,$my_grille) {
		global $module_name;
		$admin = new adminSudoku();
		$my_grille["date"] = $admin->date2AMJ($my_grille["date"]);
		return $this->sgbd->savePartieSudoku($My_SQL,$my_grille);
	}

	/**
	 * Renvoie un formulaire permettant de s'identifier si un compte client existe ou d'ouvrir le formulaire de cration de compte.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $erreur Erreur ayant empch l'identification.
	 * @param string $operation Action a effectuer sur ouverture d'un compte client.
	 * @param string $operation_open Action a effectuer sur cration d'un compte client.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function set_client($My_SQL,$vars_mod,$erreur="",$operation="new_client",$operation_open="save") {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylesudoku = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		else {
			$stylesudoku = '		<link href="'.$vars_mod["cheminModule"].'lib/style-sudoku.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$contenu = '<div align="center">';
		$contenu .= '<form action="modules.php?name='.$module_name.'&sop='.$operation_open.'" method="POST" name="compteclient">';
		$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
		$contenu .= '<tr><td class="titre">';
		$contenu .= _CATALOGClIENTCHOOSE;
		$contenu .= '</td><td width="20">';
		$contenu .= '</td><td width="1" background="'.$this->get_picto_url($vars_mod,"servert.gif").'">';
		$contenu .= '</td><td width="20">';
		$contenu .= '</td><td  class="titre">';
		$contenu .= _CATALOGClIENTNEW;
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td valign="top">';
		$contenu .= '<table border="0" cellpadding="2" cellspacing="0">';
		$contenu .= '<tr><td class="separation"></td></tr>';
		if ($erreur !="") {
			$contenu .= '<tr><td class="titre">'.$erreur.'</td></tr>';
		}
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTID.'<br />';
		$contenu .= '<input type ="text" value="" name="codeclient" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTPASSWD.'<br />';
		$contenu .= '<input type ="password" value="" name="passwd" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td class="separation"></td></tr>';
		//$contenu .= '<tr><td align="center">';
		//$contenu .= '<input type="submit" name="validb" value="'._CATALOGClIENTVALIDATE.'">';
		//$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</td><td width="20" rowspan="2">';
		$contenu .= '</td><td width="1" rowspan="2" background="'.$this->get_picto_url($vars_mod,"sepvert.gif").'">';
		$contenu .= '</td><td width="20" rowspan="2">';
		$contenu .= '</td><td valign="top">';
		$contenu .= '<table border="0" cellpadding="2" cellspacing="0">';
		$contenu .= '<tr><td class="separation"></td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTARGUE;
		$contenu .= '<tr><td class="separation"></td></tr>';
		//$contenu .= '<tr><td align="center">';
		//$contenu .= '<input type="button" name="vnewc" value="'._CATALOGClIENTJOIN.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=new_client\'">';
		//$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td align="center">';
		$contenu .= '<input type="submit" name="validb" value="'._CATALOGClIENTVALIDATE.'">';
		$contenu .= '</td><td align="center">';
		$contenu .= '<input type="button" name="vnewc" value="'._CATALOGClIENTJOIN.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop='.$operation.'\'">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td colspan="5" height="20"></td></tr>';
		$contenu .= '<tr><td colspan="5" height="1" background="'.$this->get_picto_url($vars_mod,"sephor.gif").'"></td></tr>';
		$contenu .= '<tr><td colspan="5" height="10"></td></tr>';
		$contenu .= '<tr><td align="center" colspan="5" class="titre">'._CATALOGClIENTFORGET.'</td></tr>';
		$contenu .= '<tr><td colspan="5" height="5"></td></tr>';
		$contenu .= '<tr><td align="center" colspan="5" class="titre"><input type="button" value="'._CATALOGClIENTFIND.'" onclick="window.location.href=\'modules.php?name='.$module_name.'&sop=get_ids\'"></td></tr>';
		$contenu .= '</table>';
		$contenu .= '</form>';
		$contenu .= '</div>';

		$sortie = '
		'.$stylesudoku.
		'<div class="sudokus">
			<h1>'._CATALOGClIENTCOORDS.'</h1>
			'.$contenu.'
		</div>';
		return $sortie;
	}

	/**
	 * Renvoie un formulaire permettant de crer ou modifier le compte client.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $new_client Tableau contenant le compte client.
	 * @param string $erreur Erreur ayant empch l'ergistrement prcdent.
	 * @param string $alerte_code Erreur ayant empch l'enregistrement prcdent.
	 * @param string $operation Code permettant de dterminer l'opration dclenche lors de la validation du formulaire.
	 * @return string Formulaire HTML permettant de modifier le compte client.
	 */
	function edit_client($My_SQL,$vars_mod,$new_client,$erreur="",$alerte_code="",$operation="save_new_client") {
		global $module_name, $currentlang, $seps;
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-sudoku.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		$admin = new adminSudoku();

		switch ($currentlang) {
			case "italian" :
				$suffixe = "_I";
				break;
			case "french" :
				$suffixe = "_F";
				break;
			case "spanish" :
				$suffixe = "_S";
				break;
			case "english" :
				$suffixe = "_E";
				break;
			case "german" :
				$suffixe = "_A";
				break;
		}

		$contenu = "";
		if ($erreur != "") {
			$contenu .= '<p class="alerte">'.$erreur.'<br />&nbsp;</p>';
		}
		if ($alerte_code != "") {
			$alerte_code = '<p class="alerte">'.$alerte_code.'</p>';
		}

		$pays = $this->sgbd_client->getPays($My_SQL,$suffixe);
		$menuPays = '<select name="pays" size="1" class="saisie_petit">
					<option value=""></option>';
		foreach($pays as $unpays) {
			if ($unpays["code"] == $new_client["pays"]){
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuPays .= '<option value="'.$unpays["code"].'"'.$selected.'>'.$unpays["pays".$suffixe].'</option>';
		}
		$menuPays .= '</select>';

		$new_client["datenaissance"] = $admin->date2JMA($new_client["datenaissance"]);
		$civilites = explode("//",_CLIENTCIVILITES);
		$menuCivilite = '<select name="civilite" size="1">';
		for ($i=0;$i<count($civilites);$i++) {
			if ($new_client["civilite"] == $i) {
				$selected = ' selected="selected"';
			}
			else {
				$selected = "";
			}
			$menuCivilite .= '<option value="'.$i.'"'.$selected.'>'.$civilites[$i].'</option>';
		}
		$menuCivilite .= '</select>';

		$contenu .= '<div align="center">
				<table border="0" cellpadding="0" cellspacing="0" class="setclient" id="left">
			      <tr>
			        <td style="vertical-align: top;">
			        <table style="text-align: left;" border="0" cellpadding="0" cellspacing="2" class="saisie">
			        	<tr>
			              <td style="width: 80px;">'._CLIENTCIVILITE.'</td>
			              <td>'.$menuCivilite.'</td>
			            </tr>
						<tr>
			              <td style="width: 80px;">'._CLIENTNOMEDIT.'</td>
			              <td><input type="text" name="nom" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["nom"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPRENOMEDIT.'</td>
			              <td><input type="text" name="prenom" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["prenom"]).'" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTSOCIETEEDIT.'</td>
			              <td><input type="text" name="societe" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["societe"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTADRESSEEDIT.'</td>
			              <td><textarea cols="20" rows="3" name="adresse" class="saisie_petit">'.$admin->conditionnerFORM($new_client["adresse"]).'</textarea></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTCODEPOSTALEDIT.'</td>
			              <td><input type="text" name="codepostal" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["codepostal"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTVILLEEDIT.'</td>
			              <td><input type="text" name="ville" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["ville"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPAYSEDIT.'</td>
			              <td><!--<input type="text" name="pays" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["pays"]).'" />-->'.$menuPays.'</td>
			            </tr>
			        </table>
			        </td>
			        <td style="width: 30px;">&nbsp;</td>
			        <td style="vertical-align: top;">
			        <table border="0" cellpadding="0" cellspacing="2" class="saisie">
			            <tr>
			              <td style="width: 80px;">'._CLIENTTELEDIT.'</td>
			              <td><input type="text" name="tel" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["tel"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTFAXEDIT.'</td>
			              <td><input type="text" name="fax" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["fax"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTPORTABLEEDIT.'</td>
			              <td><input type="text" name="portable" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["portable"]).'" /></td>
			            </tr>
			            <tr>
			              <td>'._CLIENTEMAILEDIT.'</td>
			              <td><input type="text" name="email" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["email"]).'" onchange="this.form.codeclient.value=this.value" /></td>
			            </tr>
						<tr>
			              <td colspan="2">'.'&nbsp;</td>
			            </tr>
			            <tr>
			              <td>'._CLIENTANIVERSAIREEDIT.'</td>
			              <td><input type="text" name="datenaissance" class="saisie_petit" value="'.$new_client["datenaissance"].'" /></td>
			            </tr>
						<tr>
			              <td colspan="2">'.$alerte_code.'&nbsp;</td>
			            </tr>
			            <tr>
			              <td>'._CLIENTCODECLIENTEDIT.'</td>
			              <td><input type="text" name="codeclient" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["codeclient"]).'" readonly="readonly" /></td>
			            </tr>
						<tr>
			              <td>'._CLIENTPASSCLIENTEDIT.'</td>
			              <td><input type="password" name="passwd" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["passwd"]).'" /></td>
			            </tr>
							<tr>
			              <td>'._CLIENTPASS2CLIENTEDIT.'</td>
			              <td><input type="password" name="passwd2" class="saisie_petit" value="'.$admin->conditionnerFORM($new_client["passwd"]).'" /></td>
			            </tr>
			        </table>
			        </td>
			      </tr>
			      <tr>
			        <td colspan="3" style="text-align: center">&nbsp;<br />'._CLIENTREQUIREDEDIT.'<br />&nbsp;<br /><input type="hidden" value="'.$new_client["Id"].'" name="'.$vars_mod["id_client"].'"><input type="hidden" value="'.$new_client["valide"].'" name="valide"><input name="validform" value="'._CLIENTSAVEEDIT.'" type="submit"></td>
			      </tr>
			  </table>
			</div>';
		if ($operation =="save_new_client_caddie") {
			$sortie = $stylecatalog.
		'<div class="sudokus">
			<h1>'._CATALOGCADDIEVERIF.'</h1>
			'.$this->command_bar($My_SQL,$vars_mod,1);
		}
		else {
			$sortie = '
			'.$stylecatalog.
		'<div class="sudokus">
			<h1>'._CATALOGClIENTCOORDSEDIT.'</h1>';
		}
		$sortie .= '
			<form method="post" action="modules.php?name='.$module_name.'&sop='.$operation.'" onsubmit="return valid(this);" name="f_client">
			'.$contenu.'
			</form>
		</div>
<script type="text/javascript">
	function validMail(email) {
		if (email == "") {
			return(true);
		}
		else {
			if ((email.indexOf("@") == -1) || (email.indexOf("@") == 0) || (email.indexOf("@") != email.lastIndexOf("@")) || (email.indexOf(".") == email.indexOf("@")-1) || (email.indexOf(".") == email.indexOf("@") + 1) || (email.indexOf("@") == email.length -1) || (email.indexOf (".") == -1) || (email.lastIndexOf (".") == email.length -1) || (email.indexOf (";") != -1) || (email.indexOf (" ") != -1)) {
				return(false);
			}
			else return(true);
		}
	}
	function valid(formulaire) {
		var ok = true;
		var compteur=0;
		
		if (formulaire.nom.value == "") {
			alert("'._CLIENTVERIFNOM.'");
			return false;
		}
		if (formulaire.prenom.value == "") {
			alert("'._CLIENTVERIFPRENOM.'");
			return false;
		}
		if (formulaire.codepostal.value == "") {
			alert("'._CLIENTVERIFCODEPOSTAL.'");
			return false;
		}
		if (formulaire.adresse.value == "") {
			alert("'._CLIENTVERIFADRESSE.'");
			return false;
		}
		if (formulaire.ville.value == "") {
			alert("'._CLIENTVERIFVILLE.'");
			return false;
		}
		if (formulaire.email.value =="") {
			alert("'._CLIENTVERIFEMAILEMPTY.'");
			return false;
		}
		/*if ((formulaire.tel.value+formulaire.fax.value+formulaire.portable.value+formulaire.email.value) == "") {
			alert("'._CLIENTVERIFCONTACT.'");
			return false;
		}*/
		if (!validMail(formulaire.email.value)) {
			alert("'._CLIENTVERIFEMAIL.'");
			return false;
		}
		if (formulaire.codeclient.value != formulaire.email.value) {
			formulaire.codeclient.value = formulaire.email.value;
		}
		if (formulaire.passwd.value == "") {
			alert("'._CLIENTVERIFPASS.'");
			return false;
		}
		if (formulaire.passwd.value != formulaire.passwd2.value) {
			alert("'._CLIENTVERIF2PASS.'");
			return false;
		}
		return ok;
	}
</script>';
		return $sortie;
	}

	/**
	 * Enregistre les modifications du compte client.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param array $new_client Tableau contenant les rubriques du compte client.
	 * @return boolean Rsultat de l'opration.
	 */
	function save_client($My_SQL,$vars_mod,$new_client) {
		$admin = new adminSudoku();
		$new_client["datenaissance"] = $admin->date2AMJ($new_client["datenaissance"]);
		$new_client["valide"] = "1";
		return $this->sgbd_client->saveClient($My_SQL,$new_client);
	}

	/**
	 * Renvoie le menu permettant d'excuter des actions lies au Sudoku.
	 *
	 * Son contenu dpend de l'tat de l'identification du client
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Barre des actions.
	 */
	function sudoku_bar($My_SQL,$vars_mod) {
		global $module_name;
		$barre .= '<table cellpadding="0" cellspacing="0" border="0" class="sudokubar" align="center"><tr>';
		$barre .= '<td>';
		if ($_SESSION["s_id_client"] == "-1") {
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=set_client">'._SUDOKUBARACCOUNT.'</a>';
		}
		else {
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=close_client">'._SUDOKUBARACCOUNTCLOSE.'</a>';
		}
		if ($_SESSION["s_id_client"] != "-1") {
			$barre .= '</td><td>';
			$barre .= '&nbsp;|&nbsp;';
			$barre .= '</td><td>';
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=edit_client">'._SUDOKUBARACCOUNTCHANGE.'</a>';
		}
		//$barre .= '</td><td>';
		//$barre .= '&nbsp;|&nbsp;';
		//$barre .= '</td><td>';
		//$barre .= '<a href="modules.php?name='.$module_name.'&sop=display_caddie">'._SUDOKUBARSHOWMYSUDOKU.'</a>';
		if ($_SESSION["s_id_client"] != "-1") {
			$barre .= '</td><td>';
			$barre .= '&nbsp;|&nbsp;';
			$barre .= '</td><td>';
			$barre .= '<a href="modules.php?name='.$module_name.'&sop=display_my_grids">'._SUDOKUBARSAVEDSUDOKU.'</a>';
		}
		$barre .= '</td><td>';
		$barre .= '&nbsp;|&nbsp;';
		$barre .= '</td><td>';
		$barre .= '<a href="modules.php?name='.$module_name.'">'._SUDOKUBARBACKTOSODKU.'</a>';
		$barre .= '</td>';
		$barre .= '</tr></table>&nbsp;<br />';

		return $barre;
	}

	/**
	 * Renvoie l'URL d'un picto.
	 *
	 * La fonction vrifie l'existance du picto dans le thme. S'il existe, son URL est envoy, sinon c'est l'URL du picto par dfaut qui est renvoy.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $picto Nom du picto  renvoyer.
	 * @return string URL du picto  afficher.
	 */
	function get_picto_url($vars_mod,$picto) {
		global $module_name;
		if (file_exists("themes/".get_theme()."/images/".$picto)) {
			$url = "themes/".get_theme()."/images/".$picto;
		}
		else {
			$url = $vars_mod["cheminModule"].'lib/icns/'.$picto;
		}
		return $url;
	}

	/**
	 * Construit la fiche du client dsign.
	 *
	 * Renvoie le code HTML de la fiche client.
	 * @param array $My_SQL Paramtres de la base de donnes
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST
	 * @return string Fiche HTML du client.
	 */
	function get_one_client($My_SQL,$vars_mod) {
		global $module_name;
		$admin = new adminSudoku();
		$clients = $this->sgbd_client->getClients($My_SQL,$vars_mod[$vars_mod["id_client"]],"");
		if (count($clients) != 0) {
			$client = $clients[0];

			$civilites = explode("//",_CLIENTCIVILITES);

			if ($client["civilite"] != 0) {
				$civilite = $civilites[$client["civilite"]]." ";
			}
			else {
				$civilite = "";
			}

			$coords_client = $civilite.$client["prenom"]." ".$client["nom"];
			if ($client["societe"] != "") {
				$coords_client .= "<br />".$client["societe"];
			}
			if ($client["adresse"] != "") {
				$coords_client .= "<br />".$client["adresse"];
			}
			$coords_client .= "<br />".$client["codepostal"]." ".$client["ville"];
			if ($client["pays"] != "") {
				$coords_client .= "<br />".$client["pays"];
			}
			$contacts_client = "";
			if ($client["tel"] != "") {
				$contacts_client .= _CLIENTTEL.$client["tel"];
			}
			if ($client["fax"] != "") {
				$contacts_client .= "<br />"._CLIENTFAX.$client["fax"];
			}
			if ($client["portable"] != "") {
				$contacts_client .= "<br />"._CLIENTPORTABLE.$client["portable"];
			}
			if ($client["email"] != "") {
				$contacts_client .= "<br />"._CLIENTEMAIL.$client["email"];
			}
			$sortie = '<center><table border="0" cellpadding="0" cellspacing="0" class="setclient">';
			$sortie .= '<tr><td valign="top">';
			$sortie .= $coords_client;
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= $contacts_client;
			$sortie .= '</td></tr>';
			$sortie .= '<tr><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td></tr>';
			$sortie .= '<tr><td valign="top">';
			$sortie .= _CLIENTCODECLIENT.$client["codeclient"];
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= _CLIENTMOTPASE.$client["passwd"];
			$sortie .= '</td></tr>';

			$sortie .= '<tr><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td></tr>';
			$sortie .= '<tr><td valign="top">';
			$sortie .= _CLIENTANNIVERSAIRE.$admin->date2JMA($client["datenaissance"]);
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			if ($client["valide"]){
				$sortie .= _CLIENTVALIDE;
			}
			else {
				$sortie .= _CLIENTNOTVALIDE;
			}
			$sortie .= '</td></tr>';

			$sortie .= '<tr><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			$sortie .= '&nbsp;';
			$sortie .= '</td></tr>';
			$sortie .= '<tr><td valign="top">';
			if ($client["services"] != "") {
				$sortie .= _CLIENTSERVICES.$client["services"];
			}
			$sortie .= '</td><td width="20">';
			$sortie .= '</td><td valign="top">';
			if ($client["divers"] != "") {
				$sortie .= _CLIENTDIVERS.$client["divers"];
			}
			$sortie .= '</td></tr>';
			$sortie .= '</table></center>';
		}
		$contenu = '
		<div class="sudokus">
			<h1>'._ONECLIENT.'</h1>
			'.$sortie.'
		</div>';

		return $contenu;
	}

	/**
	 * Renvoie un formulaire permettant de rcuprer ses identifiants sur sa messagerie.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @param string $erreur Erreur ayant empch l'expdition de l'e-mail.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function get_ids($My_SQL,$vars_mod,$erreur="") {
		global $module_name, $currentlang, $seps;
		$admin = new adminSudoku();
		if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
			$stylecatalog = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}
		else {
			$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-sudoku.css" rel="stylesheet" type="text/css" media="all"/>
		';
		}

		$contenu = '<div align="center">';
		$contenu .= '<form action="modules.php?name='.$module_name.'&sop=send_ids" method="POST" name="compteclient">';
		$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
		$contenu .= '<tr><td class="titre">';
		$contenu .= _CATALOGClIENTFORGETIDENT;
		$contenu .= '</td></tr>';
		if ($erreur !="") {
			$contenu .= '<tr><td class="titre">'.$erreur.'</td></tr>';
		}
		$contenu .= '<tr><td height="10"></td></tr>';
		$contenu .= '<tr><td>';
		$contenu .= _CATALOGClIENTMAILIDENT.'<br />';
		$contenu .= '<input type ="text" value="'.$admin->conditionnerFORM($vars_mod[$vars_mod["mailclient"]]).'" name="'.$vars_mod["mailclient"].'" class="saisie_petit">';
		$contenu .= '</td></tr>';
		$contenu .= '<tr><td height="10"></td></tr>';
		$contenu .= '<tr><td align="center">';
		$contenu .= '<input type="submit" name="validb" value="'._CATALOGClIENTVALIDATE.'">';
		$contenu .= '</td></tr>';
		$contenu .= '</table>';
		$contenu .= '</form>';
		$contenu .= '</div>';

		$sortie = $stylecatalog.
		'<div class="sudokus">
			<h1>'._CATALOGClIENTIDENTS.'</h1>
			'.$contenu.'
		</div>';
		return $sortie;
	}

	/**
	 * Envoie les identifiants retrouvs ou un formulaire permettant de ressaisir son email.
	 * @param array $My_SQL Paramtres de la base de donnes.
	 * @param array $vars_mod Tableau contenant toutes les variables passes dans l'URL, par la mthode GET ou par POST.
	 * @return string Formulaire HTML permettant de choisir le compte client.
	 */
	function send_ids($My_SQL,$vars_mod) {
		global $module_name, $currentlang, $seps;
		if ($vars_mod[$vars_mod["mailclient"]] != "") {
			if ($this->check_email($vars_mod[$vars_mod["mailclient"]])) {
				$ids = $this->sgbd_client->get_client_ids($My_SQL,$vars_mod[$vars_mod["mailclient"]]);
				if (count($ids) != 0) {
					if (file_exists("themes/".get_theme()."/style/".$module_name.".css")) {
						$stylecatalog = '		<link href="themes/'.get_theme().'/style/'.$module_name.'.css" rel="stylesheet" type="text/css" media="all"/>
					';
					}
					else {
						$stylecatalog = '		<link href="'.$vars_mod["cheminModule"].'lib/style-sudoku.css" rel="stylesheet" type="text/css" media="all"/>
					';
					}
					$message = "";
					foreach ($ids as $clientids) {
						$messagetemp = _CATALOGMESSAGEGETCLIENTIDS;
						$messagetemp = str_replace("<!--nom-->",$clientids["nom"],$messagetemp);
						$messagetemp = str_replace("<!--prenom-->",$clientids["prenom"],$messagetemp);
						$messagetemp = str_replace("<!--codeclient-->",$clientids["codeclient"],$messagetemp);
						$messagetemp = str_replace("<!--passwd-->",$clientids["passwd"],$messagetemp);
						$message .= $messagetemp."\n\n";
					}
					$sujet = _CATALOGMESSAGESUBJECTCLIENTIDS;
					if ($this->send_email($vars_mod[$vars_mod["mailclient"]],$sujet,$message)) {
						//ok
						$contenu = '<div align="center">';
						$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
						$contenu .= '<tr><td>'._CATALOGMESSAGEGETIDSOK.'</td></tr>';
						$contenu .= '</table>';
						$contenu .= '</div>';
						$sortie = $stylecatalog.
						'<div class="sudokus">
							<h1>'._CATALOGClIENTIDENTS.'</h1>
							'.$contenu.'
						</div>';
						return $sortie;
					}
					else {
						//pas ok
						$contenu = '<div align="center">';
						$contenu .= '<table border="0" cellpadding="0" cellspacing="0" class="setclient">';
						$contenu .= '<tr><td>'._CATALOGMESSAGEGETIDSERROR.'</td></tr>';
						$contenu .= '</table>';
						$contenu .= '</div>';
						$sortie = $stylecatalog.
						'<div class="sudokus">
							<h1>'._CATALOGClIENTIDENTS.'</h1>
							'.$contenu.'
						</div>';
						return $sortie;
					}
				}
				else {
					$erreur = _CATALOGMESSAGEGETIDSERROR2;
					return $this->get_ids($My_SQL,$vars_mod,$erreur);
				}
			}
			else {
				$erreur = _CATALOGMESSAGEGETIDSERROR3;
				return $this->get_ids($My_SQL,$vars_mod,$erreur);
			}
		}
		else {
			$erreur = _CATALOGMESSAGEGETIDSERROR3;
			return $this->get_ids($My_SQL,$vars_mod,$erreur);
		}
	}

	/**
	 * Vrification de la syntaxe d'un e-mail.
	 * @param string $adresse Adresse d'expdition de l'e-mail.
	 * @return boolean True si la syntaxe est correcte, false sinon.
	 */
	function check_email($adresse) {
		$Syntaxe='^[a-z0-9]+[a-z0-9?.+-_\']*@[a-z0-9_-]+(\.[a-z0-9_-]+)*\.[a-z]{2,6}$';
		if(eregi($Syntaxe,$adresse)) {
			return true;
		}
		else {
			return false;
		}
	}

	/**
	 * Expdition d'un e-mail.
	 * @param string $email Adresse d'expdition de l'e-mail.
	 * @param string $subject Sujet de l'e-mail.
	 * @param string $message Corps du massage  expdier.
	 * @return boolean True si le message a t expdi, false sinon.
	 */
	function send_email($email, $subject, $message){
		global $vars_mail;
		// En-ttes
		$headers = "From: ".$vars_mail["from"]."\n";
		$headers .= "X-Sender: ".$vars_mail["from"]."\n";
		$headers .= "X-Mailer: PHP\n";
		$headers .= "X-Priority: 1\n";
		$headers .= "Return-Path: ".$vars_mail["from"]."\n";
		$headers .= "Reply-To: ".$vars_mail["nom"]." <".$vars_mail["from"].">\n";
		$headers .= "Content-Type: text/plain; charset=iso-8859-1\n"; // Type MIME
		return mail($email, $subject, $message, $headers);
	}
}
?>